/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.internal;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private final ThreadFactory delegate = Executors.defaultThreadFactory();

    public DaemonThreadFactory(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable runnable2) {
        Thread t = this.delegate.newThread(runnable2);
        try {
            t.setDaemon(true);
            t.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t;
    }
}

