/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.internal.OtlpConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterProvider
implements ConfigurableSpanExporterProvider {
    @Override
    public SpanExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("traces", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }
}

