/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.export.RetryPolicy;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.export.AggregationTemporalitySelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.export.DefaultAggregationSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.internal.aggregator.AggregationUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class OtlpConfigUtil {
    public static final String DATA_TYPE_TRACES = "traces";
    public static final String DATA_TYPE_METRICS = "metrics";
    public static final String DATA_TYPE_LOGS = "logs";
    public static final String PROTOCOL_GRPC = "grpc";
    public static final String PROTOCOL_HTTP_PROTOBUF = "http/protobuf";

    public static String getOtlpProtocol(String dataType, ConfigProperties config) {
        String protocol = config.getString("otel.exporter.otlp." + dataType + ".protocol");
        if (protocol != null) {
            return protocol;
        }
        return config.getString("otel.exporter.otlp.protocol", PROTOCOL_GRPC);
    }

    public static void configureOtlpExporterBuilder(String dataType, ConfigProperties config, Consumer<String> setEndpoint, BiConsumer<String, String> addHeader, Consumer<String> setCompression, Consumer<Duration> setTimeout, Consumer<byte[]> setTrustedCertificates, BiConsumer<byte[], byte[]> setClientTls, Consumer<RetryPolicy> setRetryPolicy) {
        boolean retryEnabled;
        Duration timeout2;
        Map<String, String> headers;
        String protocol = OtlpConfigUtil.getOtlpProtocol(dataType, config);
        boolean isHttpProtobuf = protocol.equals(PROTOCOL_HTTP_PROTOBUF);
        URL endpoint = OtlpConfigUtil.validateEndpoint(config.getString("otel.exporter.otlp." + dataType + ".endpoint"), isHttpProtobuf);
        if (endpoint != null) {
            if (endpoint.getPath().isEmpty()) {
                endpoint = OtlpConfigUtil.createUrl(endpoint, "/");
            }
        } else {
            endpoint = OtlpConfigUtil.validateEndpoint(config.getString("otel.exporter.otlp.endpoint"), isHttpProtobuf);
            if (endpoint != null && isHttpProtobuf) {
                String path = endpoint.getPath();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + OtlpConfigUtil.signalPath(dataType);
                endpoint = OtlpConfigUtil.createUrl(endpoint, path);
            }
        }
        if (endpoint != null) {
            setEndpoint.accept(endpoint.toString());
        }
        if ((headers = config.getMap("otel.exporter.otlp." + dataType + ".headers")).isEmpty()) {
            headers = config.getMap("otel.exporter.otlp.headers");
        }
        headers.forEach(addHeader);
        String compression = config.getString("otel.exporter.otlp." + dataType + ".compression");
        if (compression == null) {
            compression = config.getString("otel.exporter.otlp.compression");
        }
        if (compression != null) {
            setCompression.accept(compression);
        }
        if ((timeout2 = config.getDuration("otel.exporter.otlp." + dataType + ".timeout")) == null) {
            timeout2 = config.getDuration("otel.exporter.otlp.timeout");
        }
        if (timeout2 != null) {
            setTimeout.accept(timeout2);
        }
        String certificatePath = config.getString(OtlpConfigUtil.determinePropertyByType(config, "otel.exporter.otlp", dataType, "certificate"));
        String clientKeyPath = config.getString(OtlpConfigUtil.determinePropertyByType(config, "otel.exporter.otlp", dataType, "client.key"));
        String clientKeyChainPath = config.getString(OtlpConfigUtil.determinePropertyByType(config, "otel.exporter.otlp", dataType, "client.certificate"));
        if (clientKeyPath != null && clientKeyChainPath == null) {
            throw new ConfigurationException("Client key provided but certification chain is missing");
        }
        if (clientKeyPath == null && clientKeyChainPath != null) {
            throw new ConfigurationException("Client key chain provided but key is missing");
        }
        byte[] certificateBytes = OtlpConfigUtil.readFileBytes(certificatePath);
        if (certificateBytes != null) {
            setTrustedCertificates.accept(certificateBytes);
        }
        byte[] clientKeyBytes = OtlpConfigUtil.readFileBytes(clientKeyPath);
        byte[] clientKeyChainBytes = OtlpConfigUtil.readFileBytes(clientKeyChainPath);
        if (clientKeyBytes != null && clientKeyChainBytes != null) {
            setClientTls.accept(clientKeyBytes, clientKeyChainBytes);
        }
        if (retryEnabled = config.getBoolean("otel.experimental.exporter.otlp.retry.enabled", false)) {
            setRetryPolicy.accept(RetryPolicy.getDefault());
        }
    }

    public static void configureOtlpAggregationTemporality(ConfigProperties config, Consumer<AggregationTemporalitySelector> aggregationTemporalitySelectorConsumer) {
        AggregationTemporalitySelector temporalitySelector;
        String temporalityStr = config.getString("otel.exporter.otlp.metrics.temporality.preference");
        if (temporalityStr == null) {
            return;
        }
        switch (temporalityStr.toLowerCase(Locale.ROOT)) {
            case "cumulative": {
                temporalitySelector = AggregationTemporalitySelector.alwaysCumulative();
                break;
            }
            case "delta": {
                temporalitySelector = AggregationTemporalitySelector.deltaPreferred();
                break;
            }
            case "lowmemory": {
                temporalitySelector = AggregationTemporalitySelector.lowMemory();
                break;
            }
            default: {
                throw new ConfigurationException("Unrecognized aggregation temporality: " + temporalityStr);
            }
        }
        aggregationTemporalitySelectorConsumer.accept(temporalitySelector);
    }

    public static void configureOtlpHistogramDefaultAggregation(ConfigProperties config, Consumer<DefaultAggregationSelector> defaultAggregationSelectorConsumer) {
        String defaultHistogramAggregation = config.getString("otel.exporter.otlp.metrics.default.histogram.aggregation");
        if (defaultHistogramAggregation == null) {
            return;
        }
        if (AggregationUtil.aggregationName(Aggregation.base2ExponentialBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            defaultAggregationSelectorConsumer.accept(DefaultAggregationSelector.getDefault().with(InstrumentType.HISTOGRAM, Aggregation.base2ExponentialBucketHistogram()));
        } else if (!AggregationUtil.aggregationName(Aggregation.explicitBucketHistogram()).equalsIgnoreCase(defaultHistogramAggregation)) {
            throw new ConfigurationException("Unrecognized default histogram aggregation: " + defaultHistogramAggregation);
        }
    }

    private static URL createUrl(URL context, String spec) {
        try {
            return new URL(context, spec);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unexpected exception creating URL.", e);
        }
    }

    @Nullable
    private static URL validateEndpoint(@Nullable String endpoint, boolean allowPath) {
        URL endpointUrl;
        if (endpoint == null) {
            return null;
        }
        try {
            endpointUrl = new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("OTLP endpoint must be a valid URL: " + endpoint, e);
        }
        if (!endpointUrl.getProtocol().equals("http") && !endpointUrl.getProtocol().equals("https")) {
            throw new ConfigurationException("OTLP endpoint scheme must be http or https: " + endpointUrl.getProtocol());
        }
        if (endpointUrl.getQuery() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a query string: " + endpointUrl.getQuery());
        }
        if (endpointUrl.getRef() != null) {
            throw new ConfigurationException("OTLP endpoint must not have a fragment: " + endpointUrl.getRef());
        }
        if (!(allowPath || endpointUrl.getPath().isEmpty() || endpointUrl.getPath().equals("/"))) {
            throw new ConfigurationException("OTLP endpoint must not have a path: " + endpointUrl.getPath());
        }
        return endpointUrl;
    }

    @Nullable
    private static byte[] readFileBytes(@Nullable String filePath) {
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new ConfigurationException("Invalid OTLP certificate/key path: " + filePath);
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)raf.length()];
            raf.readFully(bytes);
            return bytes;
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading content of file (" + filePath + ")", e);
        }
    }

    private static String determinePropertyByType(ConfigProperties config, String prefix, String dataType, String suffix) {
        String propertyToRead = prefix + "." + dataType + "." + suffix;
        if (OtlpConfigUtil.configContainsKey(config, propertyToRead)) {
            return propertyToRead;
        }
        return prefix + "." + suffix;
    }

    private static boolean configContainsKey(ConfigProperties config, String propertyToRead) {
        return config.getString(propertyToRead) != null;
    }

    private static String signalPath(String dataType) {
        switch (dataType) {
            case "metrics": {
                return "v1/metrics";
            }
            case "traces": {
                return "v1/traces";
            }
            case "logs": {
                return "v1/logs";
            }
        }
        throw new IllegalArgumentException("Cannot determine signal path for unrecognized data type: " + dataType);
    }

    private OtlpConfigUtil() {
    }
}

