/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.ProtoEnumInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.metrics.NumberDataPointMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.proto.metrics.v1.internal.Sum;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.PointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.metrics.data.SumData;
import java.io.IOException;

final class SumMarshaler
extends MarshalerWithSize {
    private final NumberDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;
    private final boolean isMonotonic;

    static SumMarshaler create(SumData<? extends PointData> sum) {
        NumberDataPointMarshaler[] dataPointMarshalers = NumberDataPointMarshaler.createRepeated(sum.getPoints());
        return new SumMarshaler(dataPointMarshalers, MetricsMarshalerUtil.mapToTemporality(sum.getAggregationTemporality()), sum.isMonotonic());
    }

    private SumMarshaler(NumberDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality, boolean isMonotonic) {
        super(SumMarshaler.calculateSize(dataPoints, aggregationTemporality, isMonotonic));
        this.dataPoints = dataPoints;
        this.aggregationTemporality = aggregationTemporality;
        this.isMonotonic = isMonotonic;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Sum.DATA_POINTS, this.dataPoints);
        output.serializeEnum(Sum.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
        output.serializeBool(Sum.IS_MONOTONIC, this.isMonotonic);
    }

    private static int calculateSize(NumberDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality, boolean isMonotonic) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Sum.DATA_POINTS, (Marshaler[])dataPoints);
        size += MarshalerUtil.sizeEnum(Sum.AGGREGATION_TEMPORALITY, aggregationTemporality);
        return size += MarshalerUtil.sizeBool(Sum.IS_MONOTONIC, isMonotonic);
    }
}

