/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.internal.InternalAttributeKeyImpl;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.CodedOutputStream;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.otlp.StringAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.proto.common.v1.internal.AnyValue;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.proto.common.v1.internal.ArrayValue;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.proto.common.v1.internal.KeyValue;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;

public final class KeyValueMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final KeyValueMarshaler[] EMPTY_REPEATED = new KeyValueMarshaler[0];
    private final byte[] keyUtf8;
    private final Marshaler value;

    public static KeyValueMarshaler[] createRepeated(Attributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final KeyValueMarshaler[] attributeMarshalers = new KeyValueMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<AttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(AttributeKey<?> attributeKey, Object o) {
                attributeMarshalers[this.index++] = KeyValueMarshaler.create(attributeKey, o);
            }
        });
        return attributeMarshalers;
    }

    private static KeyValueMarshaler create(AttributeKey<?> attributeKey, Object value) {
        byte[] keyUtf8 = attributeKey.getKey().isEmpty() ? EMPTY_BYTES : (attributeKey instanceof InternalAttributeKeyImpl ? ((InternalAttributeKeyImpl)attributeKey).getKeyUtf8() : attributeKey.getKey().getBytes(StandardCharsets.UTF_8));
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueMarshaler(keyUtf8, new StringAnyValueMarshaler(MarshalerUtil.toBytes((String)value)));
            }
            case LONG: {
                return new KeyValueMarshaler(keyUtf8, new Int64AnyValueMarshaler((Long)value));
            }
            case BOOLEAN: {
                return new KeyValueMarshaler(keyUtf8, new BoolAnyValueMarshaler((Boolean)value));
            }
            case DOUBLE: {
                return new KeyValueMarshaler(keyUtf8, new AnyDoubleFieldMarshaler((Double)value));
            }
            case STRING_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createString((List)value)));
            }
            case LONG_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createInt64((List)value)));
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createBool((List)value)));
            }
            case DOUBLE_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, new ArrayAnyValueMarshaler(ArrayValueMarshaler.createDouble((List)value)));
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    private KeyValueMarshaler(byte[] keyUtf8, Marshaler value) {
        super(KeyValueMarshaler.calculateSize(keyUtf8, value));
        this.keyUtf8 = keyUtf8;
        this.value = value;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeString(KeyValue.KEY, this.keyUtf8);
        output.serializeMessage(KeyValue.VALUE, this.value);
    }

    private static int calculateSize(byte[] keyUtf8, Marshaler value) {
        int size = 0;
        size += MarshalerUtil.sizeBytes(KeyValue.KEY, keyUtf8);
        return size += MarshalerUtil.sizeMessage(KeyValue.VALUE, value);
    }

    private static class Int64AnyValueMarshaler
    extends MarshalerWithSize {
        private final long value;

        Int64AnyValueMarshaler(long value) {
            super(Int64AnyValueMarshaler.calculateSize(value));
            this.value = value;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.writeInt64(AnyValue.INT_VALUE, this.value);
        }

        private static int calculateSize(long value) {
            return AnyValue.INT_VALUE.getTagSize() + CodedOutputStream.computeInt64SizeNoTag(value);
        }
    }

    private static class BoolAnyValueMarshaler
    extends MarshalerWithSize {
        private final boolean value;

        BoolAnyValueMarshaler(boolean value) {
            super(BoolAnyValueMarshaler.calculateSize(value));
            this.value = value;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.writeBool(AnyValue.BOOL_VALUE, this.value);
        }

        private static int calculateSize(boolean value) {
            return AnyValue.BOOL_VALUE.getTagSize() + CodedOutputStream.computeBoolSizeNoTag(value);
        }
    }

    private static class AnyDoubleFieldMarshaler
    extends MarshalerWithSize {
        private final double value;

        AnyDoubleFieldMarshaler(double value) {
            super(AnyDoubleFieldMarshaler.calculateSize(value));
            this.value = value;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.writeDouble(AnyValue.DOUBLE_VALUE, this.value);
        }

        private static int calculateSize(double value) {
            return AnyValue.DOUBLE_VALUE.getTagSize() + CodedOutputStream.computeDoubleSizeNoTag(value);
        }
    }

    private static class ArrayAnyValueMarshaler
    extends MarshalerWithSize {
        private final Marshaler value;

        private ArrayAnyValueMarshaler(Marshaler value) {
            super(ArrayAnyValueMarshaler.calculateSize(value));
            this.value = value;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.serializeMessage(AnyValue.ARRAY_VALUE, this.value);
        }

        private static int calculateSize(Marshaler value) {
            return MarshalerUtil.sizeMessage(AnyValue.ARRAY_VALUE, value);
        }
    }

    private static class ArrayValueMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        static ArrayValueMarshaler createString(List<String> values2) {
            int len = values2.size();
            Marshaler[] marshalers = new StringAnyValueMarshaler[len];
            for (int i = 0; i < len; ++i) {
                marshalers[i] = new StringAnyValueMarshaler(values2.get(i).getBytes(StandardCharsets.UTF_8));
            }
            return new ArrayValueMarshaler(marshalers);
        }

        static ArrayValueMarshaler createBool(List<Boolean> values2) {
            int len = values2.size();
            Marshaler[] marshalers = new BoolAnyValueMarshaler[len];
            for (int i = 0; i < len; ++i) {
                marshalers[i] = new BoolAnyValueMarshaler(values2.get(i));
            }
            return new ArrayValueMarshaler(marshalers);
        }

        static ArrayValueMarshaler createInt64(List<Long> values2) {
            int len = values2.size();
            Marshaler[] marshalers = new Int64AnyValueMarshaler[len];
            for (int i = 0; i < len; ++i) {
                marshalers[i] = new Int64AnyValueMarshaler(values2.get(i));
            }
            return new ArrayValueMarshaler(marshalers);
        }

        static ArrayValueMarshaler createDouble(List<Double> values2) {
            int len = values2.size();
            Marshaler[] marshalers = new AnyDoubleFieldMarshaler[len];
            for (int i = 0; i < len; ++i) {
                marshalers[i] = new AnyDoubleFieldMarshaler(values2.get(i));
            }
            return new ArrayValueMarshaler(marshalers);
        }

        private ArrayValueMarshaler(Marshaler[] values2) {
            super(ArrayValueMarshaler.calculateSize(values2));
            this.values = values2;
        }

        @Override
        public void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(ArrayValue.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] values2) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ArrayValue.VALUES, (Marshaler[])values2);
        }
    }
}

