/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.grpc;

import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.ExporterMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.grpc.GrpcExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.grpc.GrpcExporterUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.grpc.GrpcRequestBody;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.exporter.internal.retry.RetryUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.Call;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.Callback;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.Headers;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.HttpUrl;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.OkHttpClient;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.Request;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.okhttp3.Response;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_1_28_0.sdk.internal.ThrottlingLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class OkHttpGrpcExporter<T extends Marshaler>
implements GrpcExporter<T> {
    private static final String GRPC_STATUS = "grpc-status";
    private static final String GRPC_MESSAGE = "grpc-message";
    private static final Logger internalLogger = Logger.getLogger(OkHttpGrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final ExporterMetrics exporterMetrics;
    private final OkHttpClient client;
    private final HttpUrl url;
    private final Headers headers;
    private final boolean compressionEnabled;

    OkHttpGrpcExporter(String exporterName, String type, OkHttpClient client, Supplier<MeterProvider> meterProviderSupplier, String endpoint, Headers headers, boolean compressionEnabled) {
        this.type = type;
        this.exporterMetrics = ExporterMetrics.createGrpcOkHttp(exporterName, type, meterProviderSupplier);
        this.client = client;
        this.url = HttpUrl.get(endpoint);
        this.headers = headers;
        this.compressionEnabled = compressionEnabled;
    }

    @Override
    public CompletableResultCode export(T exportRequest, final int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        Request.Builder requestBuilder = new Request.Builder().url(this.url).headers(this.headers);
        GrpcRequestBody requestBody = new GrpcRequestBody((Marshaler)exportRequest, this.compressionEnabled);
        requestBuilder.post(requestBody);
        final CompletableResultCode result = new CompletableResultCode();
        this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                OkHttpGrpcExporter.this.exporterMetrics.addFailed(numItems);
                OkHttpGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + OkHttpGrpcExporter.this.type + "s. The request could not be executed. Full error message: " + e.getMessage());
                result.fail();
            }

            @Override
            public void onResponse(Call call, Response response) {
                try {
                    response.body().bytes();
                }
                catch (IOException e) {
                    OkHttpGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + OkHttpGrpcExporter.this.type + "s, could not consume server response.", e);
                    OkHttpGrpcExporter.this.exporterMetrics.addFailed(numItems);
                    result.fail();
                    return;
                }
                String status = OkHttpGrpcExporter.grpcStatus(response);
                if ("0".equals(status)) {
                    OkHttpGrpcExporter.this.exporterMetrics.addSuccess(numItems);
                    result.succeed();
                    return;
                }
                OkHttpGrpcExporter.this.exporterMetrics.addFailed(numItems);
                String codeMessage = status != null ? "gRPC status code " + status : "HTTP status code " + response.code();
                String errorMessage = OkHttpGrpcExporter.grpcMessage(response);
                if ("12".equals(status)) {
                    if (OkHttpGrpcExporter.this.loggedUnimplemented.compareAndSet(false, true)) {
                        GrpcExporterUtil.logUnimplemented(internalLogger, OkHttpGrpcExporter.this.type, errorMessage);
                    }
                } else if ("14".equals(status)) {
                    OkHttpGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + OkHttpGrpcExporter.this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + errorMessage);
                } else {
                    OkHttpGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + OkHttpGrpcExporter.this.type + "s. Server responded with " + codeMessage + ". Error message: " + errorMessage);
                }
                result.fail();
            }
        });
        return result;
    }

    @Nullable
    private static String grpcStatus(Response response) {
        String grpcStatus = response.header(GRPC_STATUS);
        if (grpcStatus == null) {
            try {
                grpcStatus = response.trailers().get(GRPC_STATUS);
            }
            catch (IOException e) {
                return null;
            }
        }
        return grpcStatus;
    }

    private static String grpcMessage(Response response) {
        String message = response.header(GRPC_MESSAGE);
        if (message == null) {
            try {
                message = response.trailers().get(GRPC_MESSAGE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (message != null) {
            return OkHttpGrpcExporter.unescape(message);
        }
        return response.message();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    public static boolean isRetryable(Response response) {
        if (!response.isSuccessful()) {
            return false;
        }
        String grpcStatus = response.header(GRPC_STATUS);
        return RetryUtil.retryableGrpcStatusCodes().contains(grpcStatus);
    }

    private static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return OkHttpGrpcExporter.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }
}

