/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.instrumentation.dropwizard5;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Snapshot;
import io.dropwizard.metrics5.Timer;
import io.prometheus.metrics.instrumentation.dropwizard5.InvalidMetricHandler;
import io.prometheus.metrics.instrumentation.dropwizard5.labels.CustomLabelMapper;
import io.prometheus.metrics.model.registry.MultiCollector;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import io.prometheus.metrics.model.snapshots.Quantiles;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DropwizardExports
implements MultiCollector {
    private static final Logger logger = Logger.getLogger(DropwizardExports.class.getName());
    private final MetricRegistry registry;
    private final MetricFilter metricFilter;
    private final Optional<CustomLabelMapper> labelMapper;
    private final InvalidMetricHandler invalidMetricHandler;

    public DropwizardExports(MetricRegistry registry) {
        this.registry = registry;
        this.metricFilter = MetricFilter.ALL;
        this.labelMapper = Optional.empty();
        this.invalidMetricHandler = InvalidMetricHandler.ALWAYS_THROW;
    }

    public DropwizardExports(MetricRegistry registry, MetricFilter metricFilter) {
        this.registry = registry;
        this.metricFilter = metricFilter;
        this.labelMapper = Optional.empty();
        this.invalidMetricHandler = InvalidMetricHandler.ALWAYS_THROW;
    }

    public DropwizardExports(MetricRegistry registry, MetricFilter metricFilter, CustomLabelMapper labelMapper) {
        this.registry = registry;
        this.metricFilter = metricFilter;
        this.labelMapper = Optional.ofNullable(labelMapper);
        this.invalidMetricHandler = InvalidMetricHandler.ALWAYS_THROW;
    }

    private DropwizardExports(MetricRegistry registry, MetricFilter metricFilter, CustomLabelMapper labelMapper, InvalidMetricHandler invalidMetricHandler) {
        this.registry = registry;
        this.metricFilter = metricFilter;
        this.labelMapper = Optional.ofNullable(labelMapper);
        this.invalidMetricHandler = invalidMetricHandler;
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    private MetricMetadata getMetricMetaData(String metricName, Metric metric) {
        String name = this.labelMapper.isPresent() ? this.labelMapper.get().getName(metricName) : metricName;
        return new MetricMetadata(PrometheusNaming.sanitizeMetricName((String)name), DropwizardExports.getHelpMessage(metricName, metric));
    }

    MetricSnapshot fromCounter(String dropwizardName, Counter counter) {
        MetricMetadata metadata = this.getMetricMetaData(dropwizardName, (Metric)counter);
        CounterSnapshot.CounterDataPointSnapshot.Builder dataPointBuilder = CounterSnapshot.CounterDataPointSnapshot.builder().value(Long.valueOf(counter.getCount()).doubleValue());
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new CounterSnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    MetricSnapshot fromGauge(String dropwizardName, Gauge<?> gauge) {
        double value;
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            logger.log(Level.FINE, String.format("Invalid type for Gauge %s: %s", PrometheusNaming.sanitizeMetricName((String)dropwizardName), obj == null ? "null" : obj.getClass().getName()));
            return null;
        }
        MetricMetadata metadata = this.getMetricMetaData(dropwizardName, (Metric)gauge);
        GaugeSnapshot.GaugeDataPointSnapshot.Builder dataPointBuilder = GaugeSnapshot.GaugeDataPointSnapshot.builder().value(value);
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new GaugeSnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    MetricSnapshot fromSnapshotAndCount(String dropwizardName, Snapshot snapshot, long count, double factor, String helpMessage) {
        Quantiles quantiles = Quantiles.builder().quantile(0.5, snapshot.getMedian() * factor).quantile(0.75, snapshot.get75thPercentile() * factor).quantile(0.95, snapshot.get95thPercentile() * factor).quantile(0.98, snapshot.get98thPercentile() * factor).quantile(0.99, snapshot.get99thPercentile() * factor).quantile(0.999, snapshot.get999thPercentile() * factor).build();
        String name = this.labelMapper.isPresent() ? this.labelMapper.get().getName(dropwizardName) : dropwizardName;
        MetricMetadata metadata = new MetricMetadata(PrometheusNaming.sanitizeMetricName((String)name), helpMessage);
        SummarySnapshot.SummaryDataPointSnapshot.Builder dataPointBuilder = SummarySnapshot.SummaryDataPointSnapshot.builder().quantiles(quantiles).count(count);
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new SummarySnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    MetricSnapshot fromHistogram(String dropwizardName, Histogram histogram) {
        return this.fromSnapshotAndCount(dropwizardName, histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardExports.getHelpMessage(dropwizardName, (Metric)histogram));
    }

    MetricSnapshot fromTimer(String dropwizardName, Timer timer) {
        return this.fromSnapshotAndCount(dropwizardName, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardExports.getHelpMessage(dropwizardName, (Metric)timer));
    }

    MetricSnapshot fromMeter(String dropwizardName, Meter meter) {
        MetricMetadata metadata = this.getMetricMetaData(dropwizardName + "_total", (Metric)meter);
        CounterSnapshot.CounterDataPointSnapshot.Builder dataPointBuilder = CounterSnapshot.CounterDataPointSnapshot.builder().value((double)meter.getCount());
        this.labelMapper.ifPresent(mapper -> dataPointBuilder.labels(mapper.getLabels(dropwizardName, Collections.emptyList(), Collections.emptyList())));
        return new CounterSnapshot(metadata, Collections.singletonList(dataPointBuilder.build()));
    }

    public MetricSnapshots collect() {
        MetricSnapshots.Builder metricSnapshots = MetricSnapshots.builder();
        this.collectMetricKind(metricSnapshots, this.registry.getGauges(this.metricFilter), this::fromGauge);
        this.collectMetricKind(metricSnapshots, this.registry.getCounters(this.metricFilter), this::fromCounter);
        this.collectMetricKind(metricSnapshots, this.registry.getHistograms(this.metricFilter), this::fromHistogram);
        this.collectMetricKind(metricSnapshots, this.registry.getTimers(this.metricFilter), this::fromTimer);
        this.collectMetricKind(metricSnapshots, this.registry.getMeters(this.metricFilter), this::fromMeter);
        return metricSnapshots.build();
    }

    private <T> void collectMetricKind(MetricSnapshots.Builder builder, Map<MetricName, T> metric, BiFunction<String, T, MetricSnapshot> toSnapshot) {
        for (Map.Entry<MetricName, T> entry : metric.entrySet()) {
            String metricName = entry.getKey().getKey();
            try {
                MetricSnapshot snapshot = toSnapshot.apply(metricName, (String)entry.getValue());
                if (snapshot == null) continue;
                builder.metricSnapshot(snapshot);
            }
            catch (Exception e) {
                if (this.invalidMetricHandler.suppressException(metricName, e)) continue;
                throw e;
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MetricRegistry registry;
        private MetricFilter metricFilter = MetricFilter.ALL;
        private CustomLabelMapper labelMapper;
        private InvalidMetricHandler invalidMetricHandler = InvalidMetricHandler.ALWAYS_THROW;

        private Builder() {
        }

        public Builder dropwizardRegistry(MetricRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder metricFilter(MetricFilter metricFilter) {
            this.metricFilter = metricFilter;
            return this;
        }

        public Builder customLabelMapper(CustomLabelMapper labelMapper) {
            this.labelMapper = labelMapper;
            return this;
        }

        public Builder invalidMetricHandler(InvalidMetricHandler invalidMetricHandler) {
            this.invalidMetricHandler = invalidMetricHandler;
            return this;
        }

        DropwizardExports build() {
            if (this.registry == null) {
                throw new IllegalArgumentException("MetricRegistry must be set");
            }
            return new DropwizardExports(this.registry, this.metricFilter, this.labelMapper, this.invalidMetricHandler);
        }

        public void register() {
            this.register(PrometheusRegistry.defaultRegistry);
        }

        public void register(PrometheusRegistry registry) {
            DropwizardExports dropwizardExports = this.build();
            registry.register((MultiCollector)dropwizardExports);
        }
    }
}

