/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.ContextPropagators;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.propagation.TextMapPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.TextMapPropagatorAndName;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.TextMapPropagatorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PropagatorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.TextMapPropagatorModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class PropagatorFactory
implements Factory<PropagatorModel, ContextPropagators> {
    private static final PropagatorFactory INSTANCE = new PropagatorFactory();

    private PropagatorFactory() {
    }

    static PropagatorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public ContextPropagators create(PropagatorModel model, DeclarativeConfigContext context) {
        String compositeList;
        List<TextMapPropagatorModel> textMapPropagatorModels = model.getComposite();
        HashSet<String> propagatorNames = new HashSet<String>();
        ArrayList<TextMapPropagator> textMapPropagators = new ArrayList<TextMapPropagator>();
        if (textMapPropagatorModels != null) {
            textMapPropagatorModels.forEach(textMapPropagatorModel -> {
                TextMapPropagatorAndName propagatorAndName = TextMapPropagatorFactory.getInstance().create((TextMapPropagatorModel)textMapPropagatorModel, context);
                textMapPropagators.add(propagatorAndName.getTextMapPropagator());
                propagatorNames.add(propagatorAndName.getName());
            });
        }
        if ((compositeList = model.getCompositeList()) != null) {
            List propagatorNamesList = Stream.of(compositeList.split(",")).map(String::trim).filter(s -> !s.isEmpty()).filter(s -> !s.equals("none")).collect(Collectors.toList());
            for (String propagatorName : propagatorNamesList) {
                if (!propagatorNames.add(propagatorName)) continue;
                textMapPropagators.add(TextMapPropagatorFactory.getPropagator(context, propagatorName).getTextMapPropagator());
            }
        }
        return ContextPropagators.create(TextMapPropagator.composite(textMapPropagators));
    }
}

