/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.InstrumentSelectorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.MetricReaderAndCardinalityLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.MetricReaderFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.ViewFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterConfigModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterConfiguratorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalMeterMatcherAndConfigModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.MeterProviderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ViewModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ViewSelectorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ViewStreamModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.ScopeConfigurator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.internal.ScopeConfiguratorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkMeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkMeterProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.CardinalityLimitSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.MeterConfig;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.SdkMeterProviderUtil;
import java.util.List;

final class MeterProviderFactory
implements Factory<MeterProviderModel, SdkMeterProviderBuilder> {
    private static final MeterProviderFactory INSTANCE = new MeterProviderFactory();

    private MeterProviderFactory() {
    }

    static MeterProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkMeterProviderBuilder create(MeterProviderModel model, DeclarativeConfigContext context) {
        ExperimentalMeterConfiguratorModel meterConfiguratorModel;
        List<ViewModel> viewModels;
        SdkMeterProviderBuilder builder = SdkMeterProvider.builder();
        List<MetricReaderModel> readerModels = model.getReaders();
        if (readerModels != null) {
            readerModels.forEach(readerModel -> {
                MetricReaderAndCardinalityLimits readerAndCardinalityLimits = MetricReaderFactory.getInstance().create((MetricReaderModel)readerModel, context);
                CardinalityLimitSelector cardinalityLimits = readerAndCardinalityLimits.getCardinalityLimitsSelector();
                if (cardinalityLimits == null) {
                    builder.registerMetricReader(readerAndCardinalityLimits.getMetricReader());
                } else {
                    builder.registerMetricReader(readerAndCardinalityLimits.getMetricReader(), cardinalityLimits);
                }
            });
        }
        if ((viewModels = model.getViews()) != null) {
            viewModels.forEach(viewModel -> {
                ViewSelectorModel selector = FileConfigUtil.requireNonNull(viewModel.getSelector(), "view selector");
                ViewStreamModel stream = FileConfigUtil.requireNonNull(viewModel.getStream(), "view stream");
                builder.registerView(InstrumentSelectorFactory.getInstance().create(selector, context), ViewFactory.getInstance().create(stream, context));
            });
        }
        if ((meterConfiguratorModel = model.getMeterConfiguratorDevelopment()) != null) {
            List<ExperimentalMeterMatcherAndConfigModel> meterMatcherAndConfigs;
            ExperimentalMeterConfigModel defaultConfigModel = meterConfiguratorModel.getDefaultConfig();
            ScopeConfiguratorBuilder<MeterConfig> configuratorBuilder = ScopeConfigurator.builder();
            if (defaultConfigModel != null) {
                configuratorBuilder.setDefault(MeterConfigFactory.INSTANCE.create(defaultConfigModel, context));
            }
            if ((meterMatcherAndConfigs = meterConfiguratorModel.getMeters()) != null) {
                for (ExperimentalMeterMatcherAndConfigModel meterMatcherAndConfig : meterMatcherAndConfigs) {
                    String name = FileConfigUtil.requireNonNull(meterMatcherAndConfig.getName(), "meter matcher name");
                    ExperimentalMeterConfigModel config = meterMatcherAndConfig.getConfig();
                    if (name == null || config == null) continue;
                    configuratorBuilder.addCondition(ScopeConfiguratorBuilder.nameMatchesGlob(name), MeterConfigFactory.INSTANCE.create(config, context));
                }
            }
            SdkMeterProviderUtil.setMeterConfigurator(builder, configuratorBuilder.build());
        }
        return builder;
    }

    private static class MeterConfigFactory
    implements Factory<ExperimentalMeterConfigModel, MeterConfig> {
        private static final MeterConfigFactory INSTANCE = new MeterConfigFactory();

        private MeterConfigFactory() {
        }

        @Override
        public MeterConfig create(ExperimentalMeterConfigModel model, DeclarativeConfigContext context) {
            if (model.getDisabled() != null && model.getDisabled().booleanValue()) {
                return MeterConfig.disabled();
            }
            return MeterConfig.defaultConfig();
        }
    }
}

