/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.state;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.state.ObjectPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class PooledHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private ArrayList<Entry<K, V>>[] table;
    private final ObjectPool<Entry<K, V>> entryPool;
    private int size;

    public PooledHashMap(int capacity) {
        this.table = new ArrayList[capacity];
        this.entryPool = new ObjectPool<Entry>(() -> new Entry());
        this.size = 0;
    }

    public PooledHashMap() {
        this(16);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        int bucket;
        ArrayList<Entry<K, V>> entries;
        Objects.requireNonNull(key, "This map does not support null keys");
        Objects.requireNonNull(value, "This map does not support null values");
        if ((float)this.size > 0.75f * (float)this.table.length) {
            this.rehash();
        }
        if ((entries = this.table[bucket = this.getBucket(key)]) == null) {
            entries = new ArrayList();
            this.table[bucket] = entries;
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                Entry<K, V> entry = entries.get(i);
                if (!Objects.equals(entry.key, key)) continue;
                Object oldValue = entry.value;
                entry.value = value;
                return oldValue;
            }
        }
        Entry<K, V> entry = this.entryPool.borrowObject();
        entry.key = key;
        entry.value = value;
        entries.add(entry);
        ++this.size;
        return null;
    }

    private void rehash() {
        ArrayList<Entry<K, V>>[] oldTable = this.table;
        this.table = new ArrayList[2 * oldTable.length];
        this.size = 0;
        for (int i = 0; i < oldTable.length; ++i) {
            ArrayList<Entry<K, V>> bucket = oldTable[i];
            if (bucket == null) continue;
            for (Entry<K, V> entry : bucket) {
                this.put(Objects.requireNonNull(entry.key), Objects.requireNonNull(entry.value));
                this.entryPool.returnObject(entry);
            }
            bucket.clear();
        }
    }

    @Override
    @Nullable
    public V get(Object key) {
        Objects.requireNonNull(key, "This map does not support null keys");
        int bucket = this.getBucket(key);
        ArrayList<Entry<K, V>> entries = this.table[bucket];
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                Entry<K, V> entry = entries.get(i);
                if (!Objects.equals(entry.key, key)) continue;
                return entry.value;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public V remove(Object key) {
        Objects.requireNonNull(key, "This map does not support null keys");
        int bucket = this.getBucket(key);
        ArrayList<Entry<K, V>> entries = this.table[bucket];
        if (entries != null) {
            for (int i = 0; i < entries.size(); ++i) {
                Entry<K, V> entry = entries.get(i);
                if (!Objects.equals(entry.key, key)) continue;
                Object oldValue = entry.value;
                entries.remove(i);
                this.entryPool.returnObject(entry);
                --this.size;
                return oldValue;
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        Objects.requireNonNull(key, "This map does not support null keys");
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            ArrayList<Entry<K, V>> bucket = this.table[i];
            if (bucket == null) continue;
            for (int j = 0; j < bucket.size(); ++j) {
                Entry<K, V> entry = bucket.get(j);
                this.entryPool.returnObject(entry);
            }
            bucket.clear();
        }
        this.size = 0;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (int j = 0; j < this.table.length; ++j) {
            ArrayList<Entry<K, V>> bucket = this.table[j];
            if (bucket == null) continue;
            for (int i = 0; i < bucket.size(); ++i) {
                Entry<K, V> entry = bucket.get(i);
                action.accept(entry.key, entry.value);
            }
        }
    }

    private int getBucket(K key) {
        return Math.abs(key.hashCode() % this.table.length);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    private static class Entry<K, V> {
        @Nullable
        K key;
        @Nullable
        V value;

        private Entry() {
        }
    }
}

