/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ParentBasedSamplerModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SamplerModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.TraceIdRatioBasedSamplerModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.samplers.ParentBasedSamplerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.trace.samplers.Sampler;
import java.util.Map;

final class SamplerFactory
implements Factory<SamplerModel, Sampler> {
    private static final SamplerFactory INSTANCE = new SamplerFactory();

    private SamplerFactory() {
    }

    static SamplerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Sampler create(SamplerModel model, DeclarativeConfigContext context) {
        if (model.getAlwaysOn() != null) {
            return Sampler.alwaysOn();
        }
        if (model.getAlwaysOff() != null) {
            return Sampler.alwaysOff();
        }
        TraceIdRatioBasedSamplerModel traceIdRatioBasedModel = model.getTraceIdRatioBased();
        if (traceIdRatioBasedModel != null) {
            Double ratio = traceIdRatioBasedModel.getRatio();
            if (ratio == null) {
                ratio = 1.0;
            }
            return Sampler.traceIdRatioBased(ratio);
        }
        ParentBasedSamplerModel parentBasedModel = model.getParentBased();
        if (parentBasedModel != null) {
            Sampler sampler;
            Sampler root = parentBasedModel.getRoot() == null ? Sampler.alwaysOn() : this.create(parentBasedModel.getRoot(), context);
            ParentBasedSamplerBuilder builder = Sampler.parentBasedBuilder(root);
            if (parentBasedModel.getRemoteParentSampled() != null) {
                sampler = this.create(parentBasedModel.getRemoteParentSampled(), context);
                builder.setRemoteParentSampled(sampler);
            }
            if (parentBasedModel.getRemoteParentNotSampled() != null) {
                sampler = this.create(parentBasedModel.getRemoteParentNotSampled(), context);
                builder.setRemoteParentNotSampled(sampler);
            }
            if (parentBasedModel.getLocalParentSampled() != null) {
                sampler = this.create(parentBasedModel.getLocalParentSampled(), context);
                builder.setLocalParentSampled(sampler);
            }
            if (parentBasedModel.getLocalParentNotSampled() != null) {
                sampler = this.create(parentBasedModel.getLocalParentNotSampled(), context);
                builder.setLocalParentNotSampled(sampler);
            }
            return builder.build();
        }
        model.getAdditionalProperties().compute("jaeger_remote", (k, v) -> model.getJaegerRemote());
        Map.Entry<String, Object> keyValue = FileConfigUtil.getSingletonMapEntry(model.getAdditionalProperties(), "sampler");
        return context.loadComponent(Sampler.class, keyValue.getKey(), keyValue.getValue());
    }
}

