/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HeaderParsingHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import java.util.Locale;

final class HttpServerAddressAndPortExtractor<REQUEST>
implements AddressAndPortExtractor<REQUEST> {
    private final HttpServerAttributesGetter<REQUEST, ?> getter;

    HttpServerAddressAndPortExtractor(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(AddressAndPortExtractor.AddressPortSink sink2, REQUEST request) {
        for (String forwarded : this.getter.getHttpRequestHeader(request, "forwarded")) {
            if (!HttpServerAddressAndPortExtractor.extractFromForwardedHeader(sink2, forwarded)) continue;
            return;
        }
        for (String forwardedFor : this.getter.getHttpRequestHeader(request, "x-forwarded-for")) {
            if (!HttpServerAddressAndPortExtractor.extractFromForwardedForHeader(sink2, forwardedFor)) continue;
            return;
        }
        sink2.setAddress(this.getter.getNetworkPeerAddress(request, null));
        Integer port = this.getter.getNetworkPeerPort(request, null);
        if (port != null && port > 0) {
            sink2.setPort(port);
        }
    }

    private static boolean extractFromForwardedHeader(AddressAndPortExtractor.AddressPortSink sink2, String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("for=");
        if (start < 0) {
            return false;
        }
        if ((start += "for=".length()) >= forwarded.length() - 1) {
            return false;
        }
        int end = forwarded.indexOf(59, start);
        if (end < 0) {
            end = forwarded.length();
        }
        return HttpServerAddressAndPortExtractor.extractClientInfo(sink2, forwarded, start, end);
    }

    private static boolean extractFromForwardedForHeader(AddressAndPortExtractor.AddressPortSink sink2, String forwardedFor) {
        return HttpServerAddressAndPortExtractor.extractClientInfo(sink2, forwardedFor, 0, forwardedFor.length());
    }

    private static boolean extractClientInfo(AddressAndPortExtractor.AddressPortSink sink2, String forwarded, int start, int end) {
        if (start >= end) {
            return false;
        }
        if (forwarded.charAt(start) == '\"') {
            int quoteEnd = forwarded.indexOf(34, start + 1);
            if (HeaderParsingHelper.notFound(quoteEnd, end)) {
                return false;
            }
            return HttpServerAddressAndPortExtractor.extractClientInfo(sink2, forwarded, start + 1, quoteEnd);
        }
        if (forwarded.charAt(start) == '[') {
            int ipv6End = forwarded.indexOf(93, start + 1);
            if (HeaderParsingHelper.notFound(ipv6End, end)) {
                return false;
            }
            sink2.setAddress(forwarded.substring(start + 1, ipv6End));
            return true;
        }
        boolean inIpv4 = false;
        for (int i = start; i < end; ++i) {
            boolean isIpv4PortSeparator;
            char c = forwarded.charAt(i);
            if (c == '.') {
                inIpv4 = true;
            }
            boolean bl = isIpv4PortSeparator = inIpv4 && c == ':';
            if (c != ',' && c != ';' && c != '\"' && !isIpv4PortSeparator) continue;
            if (i == start) {
                return false;
            }
            sink2.setAddress(forwarded.substring(start, i));
            return true;
        }
        sink2.setAddress(forwarded.substring(start, end));
        return true;
    }
}

