/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http;

import com.google.auto.value.AutoValue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.DoubleHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.DoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.Meter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.context.ContextKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter.OperationListener;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.instrumenter.OperationMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.internal.OperationMetricsUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.AutoValue_HttpClientMetrics_State;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HttpMetricsAdvice;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpClientMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("http-client-metrics-state");
    private static final Logger logger = Logger.getLogger(HttpClientMetrics.class.getName());
    private final DoubleHistogram duration;

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("http client", HttpClientMetrics::new);
    }

    private HttpClientMetrics(Meter meter) {
        DoubleHistogramBuilder stableDurationBuilder = meter.histogramBuilder("http.client.request.duration").setUnit("s").setDescription("Duration of HTTP client requests.").setExplicitBucketBoundariesAdvice(HttpMetricsAdvice.DURATION_SECONDS_BUCKETS);
        HttpMetricsAdvice.applyClientDurationAdvice(stableDurationBuilder);
        this.duration = stableDurationBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, new AutoValue_HttpClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

