/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Value;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.ArrayAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.BytesAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.IntAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.StringAnyValueMarshaler;
import java.nio.ByteBuffer;
import java.util.List;

public final class AnyValueMarshaler {
    private AnyValueMarshaler() {
    }

    public static MarshalerWithSize create(Value<?> value) {
        switch (value.getType()) {
            case STRING: {
                return StringAnyValueMarshaler.create((String)value.getValue());
            }
            case BOOLEAN: {
                return BoolAnyValueMarshaler.create((Boolean)value.getValue());
            }
            case LONG: {
                return IntAnyValueMarshaler.create((Long)value.getValue());
            }
            case DOUBLE: {
                return DoubleAnyValueMarshaler.create((Double)value.getValue());
            }
            case ARRAY: {
                return ArrayAnyValueMarshaler.createAnyValue((List)value.getValue());
            }
            case KEY_VALUE_LIST: {
                return KeyValueListAnyValueMarshaler.create((List)value.getValue());
            }
            case BYTES: {
                return BytesAnyValueMarshaler.create((ByteBuffer)value.getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported Value type: " + (Object)((Object)value.getType()));
    }
}

