/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusCounter;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusData;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusInfo;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusStateSet;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.Unit;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.DoublePointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.MetricDataType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.SumData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;
import javax.annotation.Nullable;

class PrometheusMetricData<T extends PrometheusData<?>>
implements MetricData {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final String unit;
    T data;

    PrometheusMetricData(MetricMetadata metricMetadata, T data, InstrumentationScopeInfo instrumentationScopeInfo, Resource resource) {
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.resource = resource;
        this.name = this.getNameWithoutUnit(metricMetadata);
        this.description = metricMetadata.getHelp();
        this.unit = PrometheusMetricData.convertUnit(metricMetadata.getUnit());
        this.data = data;
    }

    private String getNameWithoutUnit(MetricMetadata metricMetadata) {
        String name = metricMetadata.getName();
        if (metricMetadata.getUnit() != null) {
            String unit = metricMetadata.getUnit().toString();
            if (name.endsWith(unit)) {
                name = name.substring(0, name.length() - unit.length());
            }
            while (name.endsWith("_")) {
                name = name.substring(0, name.length() - 1);
            }
        }
        return name;
    }

    @Nullable
    static String convertUnit(@Nullable Unit unit) {
        if (unit == null) {
            return null;
        }
        switch (unit.toString()) {
            case "days": {
                return "d";
            }
            case "hours": {
                return "h";
            }
            case "minutes": {
                return "min";
            }
            case "seconds": {
                return "s";
            }
            case "milliseconds": {
                return "ms";
            }
            case "microseconds": {
                return "us";
            }
            case "nanoseconds": {
                return "ns";
            }
            case "bytes": {
                return "By";
            }
            case "kibibytes": {
                return "KiBy";
            }
            case "mebibytes": {
                return "MiBy";
            }
            case "gibibytes": {
                return "GiBy";
            }
            case "tibibytes": {
                return "TiBy";
            }
            case "kilobytes": {
                return "KBy";
            }
            case "megabytes": {
                return "MBy";
            }
            case "gigabytes": {
                return "GBy";
            }
            case "terabytes": {
                return "TBy";
            }
            case "meters": {
                return "m";
            }
            case "volts": {
                return "V";
            }
            case "amperes": {
                return "A";
            }
            case "joules": {
                return "J";
            }
            case "watts": {
                return "W";
            }
            case "grams": {
                return "g";
            }
            case "celsius": {
                return "Cel";
            }
            case "hertz": {
                return "Hz";
            }
            case "percent": {
                return "%";
            }
        }
        return unit.toString();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getUnit() {
        return this.unit;
    }

    @Override
    public MetricDataType getType() {
        return ((PrometheusData)this.data).getType();
    }

    public T getData() {
        return this.data;
    }

    @Override
    public SumData<DoublePointData> getDoubleSumData() {
        if (this.data instanceof PrometheusCounter) {
            return (PrometheusCounter)this.data;
        }
        if (this.data instanceof PrometheusStateSet) {
            return (PrometheusStateSet)this.data;
        }
        if (this.data instanceof PrometheusInfo) {
            return (PrometheusInfo)this.data;
        }
        return MetricData.super.getDoubleSumData();
    }
}

