/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.OpenTelemetrySdk;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.OpenTelemetrySdkBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.LoggerProviderAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.LoggerProviderFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.MeterProviderFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.PropagatorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.ResourceFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.TracerProviderAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.TracerProviderFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;
import java.util.Objects;

final class OpenTelemetryConfigurationFactory
implements Factory<OpenTelemetryConfigurationModel, OpenTelemetrySdk> {
    private static final String CURRENT_SUPPORTED_FILE_FORMAT = "0.4";
    private static final OpenTelemetryConfigurationFactory INSTANCE = new OpenTelemetryConfigurationFactory();

    private OpenTelemetryConfigurationFactory() {
    }

    static OpenTelemetryConfigurationFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public OpenTelemetrySdk create(OpenTelemetryConfigurationModel model, DeclarativeConfigContext context) {
        OpenTelemetrySdkBuilder builder = OpenTelemetrySdk.builder();
        if (!CURRENT_SUPPORTED_FILE_FORMAT.equals(model.getFileFormat())) {
            throw new DeclarativeConfigException("Unsupported file format. Supported formats include: 0.4");
        }
        if (Objects.equals(Boolean.TRUE, model.getDisabled())) {
            return builder.build();
        }
        if (model.getPropagator() != null) {
            builder.setPropagators(PropagatorFactory.getInstance().create(model.getPropagator(), context));
        }
        Resource resource = Resource.getDefault();
        if (model.getResource() != null) {
            resource = ResourceFactory.getInstance().create(model.getResource(), context);
        }
        if (model.getLoggerProvider() != null) {
            builder.setLoggerProvider(context.addCloseable(LoggerProviderFactory.getInstance().create(LoggerProviderAndAttributeLimits.create(model.getAttributeLimits(), model.getLoggerProvider()), context).setResource(resource).build()));
        }
        if (model.getTracerProvider() != null) {
            builder.setTracerProvider(context.addCloseable(TracerProviderFactory.getInstance().create(TracerProviderAndAttributeLimits.create(model.getAttributeLimits(), model.getTracerProvider()), context).setResource(resource).build()));
        }
        if (model.getMeterProvider() != null) {
            builder.setMeterProvider(context.addCloseable(MeterProviderFactory.getInstance().create(model.getMeterProvider(), context).setResource(resource).build()));
        }
        return context.addCloseable(builder.build());
    }
}

