/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.CardinalityLimitsFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.MetricExporterFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.MetricReaderAndCardinalityLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ExperimentalPrometheusMetricExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.MetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PeriodicMetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PullMetricExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PullMetricReaderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PushMetricExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.CardinalityLimitSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.MetricExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.PeriodicMetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.export.PeriodicMetricReaderBuilder;
import java.time.Duration;

final class MetricReaderFactory
implements Factory<MetricReaderModel, MetricReaderAndCardinalityLimits> {
    private static final MetricReaderFactory INSTANCE = new MetricReaderFactory();

    private MetricReaderFactory() {
    }

    static MetricReaderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public MetricReaderAndCardinalityLimits create(MetricReaderModel model, DeclarativeConfigContext context) {
        PeriodicMetricReaderModel periodicModel = model.getPeriodic();
        if (periodicModel != null) {
            return PeriodicMetricReaderFactory.INSTANCE.create(periodicModel, context);
        }
        PullMetricReaderModel pullModel = model.getPull();
        if (pullModel != null) {
            return PullMetricReaderFactory.INSTANCE.create(pullModel, context);
        }
        throw new DeclarativeConfigException("reader must be set");
    }

    private static class PeriodicMetricReaderFactory
    implements Factory<PeriodicMetricReaderModel, MetricReaderAndCardinalityLimits> {
        private static final PeriodicMetricReaderFactory INSTANCE = new PeriodicMetricReaderFactory();

        private PeriodicMetricReaderFactory() {
        }

        @Override
        public MetricReaderAndCardinalityLimits create(PeriodicMetricReaderModel model, DeclarativeConfigContext context) {
            PushMetricExporterModel exporterModel = FileConfigUtil.requireNonNull(model.getExporter(), "periodic metric reader exporter");
            MetricExporter metricExporter = MetricExporterFactory.getInstance().create(exporterModel, context);
            PeriodicMetricReaderBuilder builder = PeriodicMetricReader.builder(context.addCloseable(metricExporter));
            if (model.getInterval() != null) {
                builder.setInterval(Duration.ofMillis(model.getInterval().intValue()));
            }
            CardinalityLimitSelector cardinalityLimitSelector = null;
            if (model.getCardinalityLimits() != null) {
                cardinalityLimitSelector = CardinalityLimitsFactory.getInstance().create(model.getCardinalityLimits(), context);
            }
            MetricReader reader = context.addCloseable(builder.build());
            return MetricReaderAndCardinalityLimits.create(reader, cardinalityLimitSelector);
        }
    }

    private static class PullMetricReaderFactory
    implements Factory<PullMetricReaderModel, MetricReaderAndCardinalityLimits> {
        private static final PullMetricReaderFactory INSTANCE = new PullMetricReaderFactory();

        private PullMetricReaderFactory() {
        }

        @Override
        public MetricReaderAndCardinalityLimits create(PullMetricReaderModel model, DeclarativeConfigContext context) {
            PullMetricExporterModel exporterModel = FileConfigUtil.requireNonNull(model.getExporter(), "pull metric reader exporter");
            ExperimentalPrometheusMetricExporterModel prometheusModel = exporterModel.getPrometheusDevelopment();
            if (prometheusModel != null) {
                MetricReader metricReader = context.addCloseable(context.loadComponent(MetricReader.class, "prometheus", prometheusModel));
                CardinalityLimitSelector cardinalityLimitSelector = null;
                if (model.getCardinalityLimits() != null) {
                    cardinalityLimitSelector = CardinalityLimitsFactory.getInstance().create(model.getCardinalityLimits(), context);
                }
                return MetricReaderAndCardinalityLimits.create(metricReader, cardinalityLimitSelector);
            }
            throw new DeclarativeConfigException("prometheus is the only currently supported pull reader");
        }
    }
}

