/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.config.DeclarativeConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfiguration;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class DeclarativeConfigContext {
    private final SpiHelper spiHelper;
    private final List<Closeable> closeables = new ArrayList<Closeable>();

    DeclarativeConfigContext(SpiHelper spiHelper) {
        this.spiHelper = spiHelper;
    }

    <T extends Closeable> T addCloseable(T closeable) {
        this.closeables.add(closeable);
        return closeable;
    }

    List<Closeable> getCloseables() {
        return Collections.unmodifiableList(this.closeables);
    }

    <T> T loadComponent(Class<T> type, String name, Object model) {
        DeclarativeConfigProperties config = DeclarativeConfiguration.toConfigProperties(model, this.spiHelper.getComponentLoader());
        List<ComponentProvider> componentProviders = this.spiHelper.load(ComponentProvider.class);
        List matchedProviders = componentProviders.stream().map(componentProvider -> componentProvider).filter(componentProvider -> componentProvider.getType() == type && name.equals(componentProvider.getName())).collect(Collectors.toList());
        if (matchedProviders.isEmpty()) {
            throw new DeclarativeConfigException("No component provider detected for " + type.getName() + " with name \"" + name + "\".");
        }
        if (matchedProviders.size() > 1) {
            throw new DeclarativeConfigException("Component provider conflict. Multiple providers detected for " + type.getName() + " with name \"" + name + "\": " + componentProviders.stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(",", "[", "]")));
        }
        ComponentProvider provider2 = (ComponentProvider)matchedProviders.get(0);
        try {
            return provider2.create(config);
        }
        catch (Throwable throwable) {
            throw new DeclarativeConfigException("Error configuring " + type.getName() + " with name \"" + name + "\"", throwable);
        }
    }
}

