/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.logs;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.trace.SpanContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.trace.SpanId;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.trace.TraceId;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerContext;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.StatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.marshal.StatelessMarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.AnyValueStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.IncubatingUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.exporter.internal.otlp.logs.LogMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.proto.logs.v1.internal.LogRecord;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.logs.data.LogRecordData;
import java.io.IOException;

final class LogStatelessMarshaler
implements StatelessMarshaler<LogRecordData> {
    private static final String INVALID_TRACE_ID = TraceId.getInvalid();
    private static final String INVALID_SPAN_ID = SpanId.getInvalid();
    private static final boolean INCUBATOR_AVAILABLE;
    static final LogStatelessMarshaler INSTANCE;

    LogStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, LogRecordData log, MarshalerContext context) throws IOException {
        int droppedAttributesCount;
        output.serializeFixed64(LogRecord.TIME_UNIX_NANO, log.getTimestampEpochNanos());
        output.serializeFixed64(LogRecord.OBSERVED_TIME_UNIX_NANO, log.getObservedTimestampEpochNanos());
        output.serializeEnum(LogRecord.SEVERITY_NUMBER, LogMarshaler.toProtoSeverityNumber(log.getSeverity()));
        output.serializeStringWithContext(LogRecord.SEVERITY_TEXT, log.getSeverityText(), context);
        if (log.getBodyValue() != null) {
            output.serializeMessageWithContext(LogRecord.BODY, log.getBodyValue(), AnyValueStatelessMarshaler.INSTANCE, context);
        }
        if (INCUBATOR_AVAILABLE) {
            IncubatingUtil.serializeExtendedAttributes(output, log, context);
            droppedAttributesCount = log.getTotalAttributeCount() - IncubatingUtil.extendedAttributesSize(log);
        } else {
            output.serializeRepeatedMessageWithContext(LogRecord.ATTRIBUTES, log.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
            droppedAttributesCount = log.getTotalAttributeCount() - log.getAttributes().size();
        }
        output.serializeUInt32(LogRecord.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        SpanContext spanContext = log.getSpanContext();
        output.serializeFixed32(LogRecord.FLAGS, spanContext.getTraceFlags().asByte());
        if (!spanContext.getTraceId().equals(INVALID_TRACE_ID)) {
            output.serializeTraceId(LogRecord.TRACE_ID, spanContext.getTraceId(), context);
        }
        if (!spanContext.getSpanId().equals(INVALID_SPAN_ID)) {
            output.serializeSpanId(LogRecord.SPAN_ID, spanContext.getSpanId(), context);
        }
        output.serializeStringWithContext(LogRecord.EVENT_NAME, log.getEventName(), context);
    }

    @Override
    public int getBinarySerializedSize(LogRecordData log, MarshalerContext context) {
        int droppedAttributesCount;
        int size = 0;
        size += MarshalerUtil.sizeFixed64(LogRecord.TIME_UNIX_NANO, log.getTimestampEpochNanos());
        size += MarshalerUtil.sizeFixed64(LogRecord.OBSERVED_TIME_UNIX_NANO, log.getObservedTimestampEpochNanos());
        size += MarshalerUtil.sizeEnum(LogRecord.SEVERITY_NUMBER, LogMarshaler.toProtoSeverityNumber(log.getSeverity()));
        size += StatelessMarshalerUtil.sizeStringWithContext(LogRecord.SEVERITY_TEXT, log.getSeverityText(), context);
        if (log.getBodyValue() != null) {
            size += StatelessMarshalerUtil.sizeMessageWithContext(LogRecord.BODY, log.getBodyValue(), AnyValueStatelessMarshaler.INSTANCE, context);
        }
        if (INCUBATOR_AVAILABLE) {
            size += IncubatingUtil.sizeExtendedAttributes(log, context);
            droppedAttributesCount = log.getTotalAttributeCount() - IncubatingUtil.extendedAttributesSize(log);
            size += MarshalerUtil.sizeUInt32(LogRecord.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        } else {
            size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(LogRecord.ATTRIBUTES, log.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
            droppedAttributesCount = log.getTotalAttributeCount() - log.getAttributes().size();
            size += MarshalerUtil.sizeUInt32(LogRecord.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        }
        SpanContext spanContext = log.getSpanContext();
        size += MarshalerUtil.sizeFixed32(LogRecord.FLAGS, spanContext.getTraceFlags().asByte());
        if (!spanContext.getTraceId().equals(INVALID_TRACE_ID)) {
            size += MarshalerUtil.sizeTraceId(LogRecord.TRACE_ID, spanContext.getTraceId());
        }
        if (!spanContext.getSpanId().equals(INVALID_SPAN_ID)) {
            size += MarshalerUtil.sizeSpanId(LogRecord.SPAN_ID, spanContext.getSpanId());
        }
        return size += StatelessMarshalerUtil.sizeStringWithContext(LogRecord.EVENT_NAME, log.getEventName(), context);
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.incubator.common.ExtendedAttributes");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
        INSTANCE = new LogStatelessMarshaler();
    }
}

