/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusClassicHistogram;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusCounter;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusGauge;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusInfo;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusMetricData;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusNativeHistogram;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusStateSet;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusSummary;
import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PrometheusUnknown;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.resources.Resource;

public class MetricDataFactory {
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long currentTimeMillis;

    public MetricDataFactory(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long currentTimeMillis) {
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.currentTimeMillis = currentTimeMillis;
    }

    public MetricData create(CounterSnapshot snapshot) {
        return new PrometheusMetricData<PrometheusCounter>(snapshot.getMetadata(), new PrometheusCounter(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
    }

    public MetricData create(GaugeSnapshot snapshot) {
        return new PrometheusMetricData<PrometheusGauge>(snapshot.getMetadata(), new PrometheusGauge(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
    }

    public MetricData create(HistogramSnapshot snapshot) {
        if (!snapshot.getDataPoints().isEmpty()) {
            HistogramSnapshot.HistogramDataPointSnapshot firstDataPoint = (HistogramSnapshot.HistogramDataPointSnapshot)snapshot.getDataPoints().get(0);
            if (firstDataPoint.hasNativeHistogramData()) {
                return new PrometheusMetricData<PrometheusNativeHistogram>(snapshot.getMetadata(), new PrometheusNativeHistogram(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
            }
            if (firstDataPoint.hasClassicHistogramData()) {
                return new PrometheusMetricData<PrometheusClassicHistogram>(snapshot.getMetadata(), new PrometheusClassicHistogram(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
            }
        }
        return null;
    }

    public MetricData create(SummarySnapshot snapshot) {
        return new PrometheusMetricData<PrometheusSummary>(snapshot.getMetadata(), new PrometheusSummary(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
    }

    public MetricData create(InfoSnapshot snapshot) {
        return new PrometheusMetricData<PrometheusInfo>(snapshot.getMetadata(), new PrometheusInfo(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
    }

    public MetricData create(StateSetSnapshot snapshot) {
        return new PrometheusMetricData<PrometheusStateSet>(snapshot.getMetadata(), new PrometheusStateSet(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
    }

    public MetricData create(UnknownSnapshot snapshot) {
        return new PrometheusMetricData<PrometheusUnknown>(snapshot.getMetadata(), new PrometheusUnknown(snapshot, this.currentTimeMillis), this.instrumentationScopeInfo, this.resource);
    }
}

