/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.exporter.opentelemetry.otelmodel;

import io.prometheus.metrics.exporter.opentelemetry.otelmodel.PointDataImpl;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.ExponentialHistogramBuckets;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.data.ExponentialHistogramPointData;
import java.util.List;

public class ExponentialHistogramPointDataImpl
extends PointDataImpl
implements ExponentialHistogramPointData {
    private final int scale;
    private final double sum;
    private final long count;
    private final long zeroCount;
    private final double min;
    private final double max;
    private final ExponentialHistogramBuckets positiveBuckets;
    private final ExponentialHistogramBuckets negativeBuckets;

    ExponentialHistogramPointDataImpl(int scale, double sum, long count, long zeroCount, double min, double max, ExponentialHistogramBuckets positiveBuckets, ExponentialHistogramBuckets negativeBuckets, long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars) {
        super(startEpochNanos, epochNanos, attributes, exemplars);
        this.scale = scale;
        this.sum = sum;
        this.count = count;
        this.zeroCount = zeroCount;
        this.min = min;
        this.max = max;
        this.positiveBuckets = positiveBuckets;
        this.negativeBuckets = negativeBuckets;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getZeroCount() {
        return this.zeroCount;
    }

    @Override
    public boolean hasMin() {
        return !Double.isNaN(this.min);
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public boolean hasMax() {
        return !Double.isNaN(this.max);
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public ExponentialHistogramBuckets getPositiveBuckets() {
        return this.positiveBuckets;
    }

    @Override
    public ExponentialHistogramBuckets getNegativeBuckets() {
        return this.negativeBuckets;
    }
}

