/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.ObservableDoubleMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.api.metrics.ObservableLongMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.SdkObservableInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.descriptor.Advice;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.state.CallbackRegistration;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.state.SdkObservableMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

final class InstrumentBuilder {
    private final String name;
    private final SdkMeter sdkMeter;
    private final InstrumentValueType valueType;
    private InstrumentType type;
    private Advice.AdviceBuilder adviceBuilder = Advice.builder();
    private String description = "";
    private String unit = "";

    InstrumentBuilder(String name, InstrumentType type, InstrumentValueType valueType, SdkMeter sdkMeter) {
        this.name = name;
        this.type = type;
        this.valueType = valueType;
        this.sdkMeter = sdkMeter;
    }

    InstrumentBuilder setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    InstrumentBuilder setAdviceBuilder(Advice.AdviceBuilder adviceBuilder) {
        this.adviceBuilder = adviceBuilder;
        return this;
    }

    InstrumentBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.sdkMeter, this.name, this.description, this.unit, this.adviceBuilder);
    }

    <I extends AbstractInstrument> I buildSynchronousInstrument(SynchronousInstrumentConstructor<I> instrumentFactory) {
        InstrumentDescriptor descriptor = this.newDescriptor();
        WriteableMetricStorage storage = this.sdkMeter.registerSynchronousMetricStorage(descriptor);
        return instrumentFactory.createInstrument(descriptor, this.sdkMeter, storage);
    }

    SdkObservableInstrument buildDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable2 = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable2);
        this.sdkMeter.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.sdkMeter, callbackRegistration);
    }

    SdkObservableInstrument buildLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable2 = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable2);
        this.sdkMeter.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.sdkMeter, callbackRegistration);
    }

    SdkObservableMeasurement buildObservableMeasurement(InstrumentType type) {
        this.type = type;
        InstrumentDescriptor descriptor = this.newDescriptor();
        return this.sdkMeter.registerObservableMeasurement(descriptor);
    }

    private InstrumentDescriptor newDescriptor() {
        return InstrumentDescriptor.create(this.name, this.description, this.unit, this.type, this.valueType, this.adviceBuilder.build());
    }

    public String toString() {
        return this.toStringHelper(this.getClass().getSimpleName());
    }

    String toStringHelper(String className) {
        return className + "{descriptor=" + this.newDescriptor() + "}";
    }

    void setAdviceAttributes(List<AttributeKey<?>> attributes) {
        this.adviceBuilder.setAttributes(attributes);
    }

    void setExplicitBucketBoundaries(List<Double> bucketBoundaries) {
        this.adviceBuilder.setExplicitBucketBoundaries(bucketBoundaries);
    }

    @FunctionalInterface
    static interface SwapBuilder<T> {
        public T newBuilder(SdkMeter var1, String var2, String var3, String var4, Advice.AdviceBuilder var5);
    }

    @FunctionalInterface
    static interface SynchronousInstrumentConstructor<I extends AbstractInstrument> {
        public I createInstrument(InstrumentDescriptor var1, SdkMeter var2, WriteableMetricStorage var3);
    }
}

