/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HeaderParsingHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_16_0_alpha.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import java.util.Locale;

final class ForwardedHostAddressAndPortExtractor<REQUEST>
implements AddressAndPortExtractor<REQUEST> {
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;

    ForwardedHostAddressAndPortExtractor(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public void extract(AddressAndPortExtractor.AddressPortSink sink2, REQUEST request) {
        for (String forwarded : this.getter.getHttpRequestHeader(request, "forwarded")) {
            if (!ForwardedHostAddressAndPortExtractor.extractFromForwardedHeader(sink2, forwarded)) continue;
            return;
        }
        for (String forwardedHost : this.getter.getHttpRequestHeader(request, "x-forwarded-host")) {
            if (!ForwardedHostAddressAndPortExtractor.extractHost(sink2, forwardedHost, 0, forwardedHost.length())) continue;
            return;
        }
        for (String host : this.getter.getHttpRequestHeader(request, ":authority")) {
            if (!ForwardedHostAddressAndPortExtractor.extractHost(sink2, host, 0, host.length())) continue;
            return;
        }
        for (String host : this.getter.getHttpRequestHeader(request, "host")) {
            if (!ForwardedHostAddressAndPortExtractor.extractHost(sink2, host, 0, host.length())) continue;
            return;
        }
    }

    private static boolean extractFromForwardedHeader(AddressAndPortExtractor.AddressPortSink sink2, String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("host=");
        if (start < 0) {
            return false;
        }
        if ((start += "host=".length()) >= forwarded.length() - 1) {
            return false;
        }
        int end = forwarded.indexOf(59, start);
        if (end < 0) {
            end = forwarded.length();
        }
        return ForwardedHostAddressAndPortExtractor.extractHost(sink2, forwarded, start, end);
    }

    private static boolean extractHost(AddressAndPortExtractor.AddressPortSink sink2, String host, int start, int end) {
        if (start >= end) {
            return false;
        }
        if (host.charAt(start) == '\"') {
            int quoteEnd = host.indexOf(34, start + 1);
            if (HeaderParsingHelper.notFound(quoteEnd, end)) {
                return false;
            }
            return ForwardedHostAddressAndPortExtractor.extractHost(sink2, host, start + 1, quoteEnd);
        }
        int hostHeaderSeparator = host.indexOf(58, start);
        if (HeaderParsingHelper.notFound(hostHeaderSeparator, end)) {
            sink2.setAddress(host.substring(start, end));
        } else {
            sink2.setAddress(host.substring(start, hostHeaderSeparator));
            HeaderParsingHelper.setPort(sink2, host, hostHeaderSeparator + 1, end);
        }
        return true;
    }
}

