/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.aggregator;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.export.MemoryMode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.data.AggregationTemporality;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.data.LongExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.data.LongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.data.MetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.aggregator.Aggregator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.data.ImmutableGaugeData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.data.ImmutableLongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.data.ImmutableMetricData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.data.MutableLongPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.state.Measurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class LongLastValueAggregator
implements Aggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public LongLastValueAggregator(Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previous, LongPointData current) {
        return current;
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint);
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public void toPoint(Measurement measurement, LongPointData reusablePoint) {
        ((MutableLongPointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);
        @Nullable
        private final MutableLongPointData reusablePoint;

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            Long value;
            Long l = value = reset ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
                return this.reusablePoint;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

