/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.DoubleUpDownCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.LongUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.LongUpDownCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.ObservableLongMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.ObservableLongUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.SdkDoubleUpDownCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

class SdkLongUpDownCounter
extends AbstractInstrument
implements LongUpDownCounter {
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkLongUpDownCounter(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    static class SdkLongUpDownCounterBuilder
    implements LongUpDownCounterBuilder {
        final InstrumentBuilder builder;

        SdkLongUpDownCounterBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG, sdkMeter);
        }

        @Override
        public LongUpDownCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public LongUpDownCounter build() {
            return this.builder.buildSynchronousInstrument(SdkLongUpDownCounter::new);
        }

        @Override
        public DoubleUpDownCounterBuilder ofDoubles() {
            return this.builder.swapBuilder(SdkDoubleUpDownCounter.SdkDoubleUpDownCounterBuilder::new);
        }

        @Override
        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

