/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.export;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.export.LogRecordExporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MultiLogRecordExporter
implements LogRecordExporter {
    private static final Logger logger = Logger.getLogger(MultiLogRecordExporter.class.getName());
    private final LogRecordExporter[] logRecordExporters;

    private MultiLogRecordExporter(LogRecordExporter[] logRecordExporters) {
        this.logRecordExporters = logRecordExporters;
    }

    static LogRecordExporter create(List<LogRecordExporter> logRecordExporters) {
        return new MultiLogRecordExporter(logRecordExporters.toArray(new LogRecordExporter[0]));
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode exportResult;
            try {
                exportResult = logRecordExporter.export(logs);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exception thrown by the export.", e);
                results.add(CompletableResultCode.ofFailure());
                continue;
            }
            results.add(exportResult);
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode flush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode flushResult;
            try {
                flushResult = logRecordExporter.flush();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exception thrown by the flush.", e);
                results.add(CompletableResultCode.ofFailure());
                continue;
            }
            results.add(flushResult);
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode shutdown() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logRecordExporters.length);
        for (LogRecordExporter logRecordExporter : this.logRecordExporters) {
            CompletableResultCode shutdownResult;
            try {
                shutdownResult = logRecordExporter.shutdown();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exception thrown by the shutdown.", e);
                results.add(CompletableResultCode.ofFailure());
                continue;
            }
            results.add(shutdownResult);
        }
        return CompletableResultCode.ofAll(results);
    }

    public String toString() {
        return "MultiLogRecordExporter{logRecordExporters=" + Arrays.toString(this.logRecordExporters) + '}';
    }
}

