/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.JaegerRemoteModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.ParentBasedModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SamplerModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.TraceIdRatioBasedModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.samplers.ParentBasedSamplerBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.samplers.Sampler;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class SamplerFactory
implements Factory<SamplerModel, Sampler> {
    private static final SamplerFactory INSTANCE = new SamplerFactory();

    private SamplerFactory() {
    }

    static SamplerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public Sampler create(SamplerModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model.getAlwaysOn() != null) {
            return Sampler.alwaysOn();
        }
        if (model.getAlwaysOff() != null) {
            return Sampler.alwaysOff();
        }
        TraceIdRatioBasedModel traceIdRatioBasedModel = model.getTraceIdRatioBased();
        if (traceIdRatioBasedModel != null) {
            Double ratio = traceIdRatioBasedModel.getRatio();
            if (ratio == null) {
                ratio = 1.0;
            }
            return Sampler.traceIdRatioBased(ratio);
        }
        ParentBasedModel parentBasedModel = model.getParentBased();
        if (parentBasedModel != null) {
            Sampler sampler;
            Sampler root = parentBasedModel.getRoot() == null ? Sampler.alwaysOn() : this.create(parentBasedModel.getRoot(), spiHelper, closeables);
            ParentBasedSamplerBuilder builder = Sampler.parentBasedBuilder(root);
            if (parentBasedModel.getRemoteParentSampled() != null) {
                sampler = this.create(parentBasedModel.getRemoteParentSampled(), spiHelper, closeables);
                builder.setRemoteParentSampled(sampler);
            }
            if (parentBasedModel.getRemoteParentNotSampled() != null) {
                sampler = this.create(parentBasedModel.getRemoteParentNotSampled(), spiHelper, closeables);
                builder.setRemoteParentNotSampled(sampler);
            }
            if (parentBasedModel.getLocalParentSampled() != null) {
                sampler = this.create(parentBasedModel.getLocalParentSampled(), spiHelper, closeables);
                builder.setLocalParentSampled(sampler);
            }
            if (parentBasedModel.getLocalParentNotSampled() != null) {
                sampler = this.create(parentBasedModel.getLocalParentNotSampled(), spiHelper, closeables);
                builder.setLocalParentNotSampled(sampler);
            }
            return builder.build();
        }
        JaegerRemoteModel jaegerRemoteModel = model.getJaegerRemote();
        if (jaegerRemoteModel != null) {
            model.getAdditionalProperties().put("jaeger_remote", jaegerRemoteModel);
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new DeclarativeConfigException("Invalid configuration - multiple samplers exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing sampler. This is a programming error."));
            Sampler sampler = FileConfigUtil.loadComponent(spiHelper, Sampler.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, sampler);
        }
        throw new DeclarativeConfigException("sampler must be set");
    }
}

