/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.baggage.propagation.W3CBaggagePropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.trace.propagation.W3CTraceContextPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.propagation.ContextPropagators;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.propagation.TextMapPropagator;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.NamedSpiManager;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiFunction;

final class PropagatorConfiguration {
    private static final List<String> DEFAULT_PROPAGATORS = Arrays.asList("tracecontext", "baggage");

    static ContextPropagators configurePropagators(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer) {
        LinkedHashSet<TextMapPropagator> propagators = new LinkedHashSet<TextMapPropagator>();
        List<String> requestedPropagators = config.getList("otel.propagators", DEFAULT_PROPAGATORS);
        NamedSpiManager<TextMapPropagator> spiPropagatorsManager = spiHelper.loadConfigurable(ConfigurablePropagatorProvider.class, ConfigurablePropagatorProvider::getName, ConfigurablePropagatorProvider::getPropagator, config);
        if (requestedPropagators.contains("none")) {
            if (requestedPropagators.size() > 1) {
                throw new ConfigurationException("otel.propagators contains 'none' along with other propagators");
            }
            return ContextPropagators.noop();
        }
        for (String propagatorName : requestedPropagators) {
            propagators.add(propagatorCustomizer.apply(PropagatorConfiguration.getPropagator(propagatorName, spiPropagatorsManager), config));
        }
        return ContextPropagators.create(TextMapPropagator.composite(propagators));
    }

    private static TextMapPropagator getPropagator(String name, NamedSpiManager<TextMapPropagator> spiPropagatorsManager) {
        if (name.equals("tracecontext")) {
            return W3CTraceContextPropagator.getInstance();
        }
        if (name.equals("baggage")) {
            return W3CBaggagePropagator.getInstance();
        }
        TextMapPropagator spiPropagator = spiPropagatorsManager.getByName(name);
        if (spiPropagator != null) {
            return spiPropagator;
        }
        throw new ConfigurationException("Unrecognized value for otel.propagators: " + name + ". Make sure the artifact including the propagator is on the classpath.");
    }

    private PropagatorConfiguration() {
    }
}

