/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin.io.encoding;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin.Metadata;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin.collections.ArraysKt;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin.io.encoding.Base64;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin.io.encoding.ExperimentalEncodingApi;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin.jvm.internal.Intrinsics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.org.jetbrains.annotations.NotNull;
import java.io.IOException;
import java.io.OutputStream;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/prometheus/metrics/shaded/io_opentelemetry_2_15_0_alpha/kotlin/io/encoding/EncodeOutputStream;", "Ljava/io/OutputStream;", "output", "base64", "Lio/prometheus/metrics/shaded/io_opentelemetry_2_15_0_alpha/kotlin/io/encoding/Base64;", "(Ljava/io/OutputStream;Lkotlin/io/encoding/Base64;)V", "byteBuffer", "", "byteBufferLength", "", "isClosed", "", "lineLength", "symbolBuffer", "checkOpen", "", "close", "copyIntoByteBuffer", "source", "startIndex", "endIndex", "encodeByteBufferIntoOutput", "encodeIntoOutput", "flush", "write", "offset", "length", "b", "io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.kotlin-stdlib"})
@ExperimentalEncodingApi
final class EncodeOutputStream
extends OutputStream {
    @NotNull
    private final OutputStream output;
    @NotNull
    private final Base64 base64;
    private boolean isClosed;
    private int lineLength;
    @NotNull
    private final byte[] symbolBuffer;
    @NotNull
    private final byte[] byteBuffer;
    private int byteBufferLength;

    public EncodeOutputStream(@NotNull OutputStream output, @NotNull Base64 base64) {
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(base64, "base64");
        this.output = output;
        this.base64 = base64;
        this.lineLength = this.base64.isMimeScheme$kotlin_stdlib() ? 76 : -1;
        this.symbolBuffer = new byte[1024];
        this.byteBuffer = new byte[3];
    }

    @Override
    public void write(int b) {
        this.checkOpen();
        int n = this.byteBufferLength;
        this.byteBufferLength = n + 1;
        this.byteBuffer[n] = (byte)b;
        if (this.byteBufferLength == 3) {
            this.encodeByteBufferIntoOutput();
        }
    }

    @Override
    public void write(@NotNull byte[] source2, int offset, int length) {
        boolean bl;
        Intrinsics.checkNotNullParameter(source2, "source");
        this.checkOpen();
        if (offset < 0 || length < 0 || offset + length > source2.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", source size: " + source2.length);
        }
        if (length == 0) {
            return;
        }
        boolean bl2 = bl = this.byteBufferLength < 3;
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        int startIndex = offset;
        int endIndex = startIndex + length;
        if (this.byteBufferLength != 0) {
            startIndex += this.copyIntoByteBuffer(source2, startIndex, endIndex);
            if (this.byteBufferLength != 0) {
                return;
            }
        }
        while (startIndex + 3 <= endIndex) {
            boolean bl3;
            int groupCapacity = (this.base64.isMimeScheme$kotlin_stdlib() ? this.lineLength : this.symbolBuffer.length) / 4;
            int groupsToEncode = Math.min(groupCapacity, (endIndex - startIndex) / 3);
            int bytesToEncode = groupsToEncode * 3;
            int symbolsEncoded = this.encodeIntoOutput(source2, startIndex, startIndex + bytesToEncode);
            boolean bl4 = bl3 = symbolsEncoded == groupsToEncode * 4;
            if (!bl3) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            startIndex += bytesToEncode;
        }
        ArraysKt.copyInto(source2, this.byteBuffer, 0, startIndex, endIndex);
        this.byteBufferLength = endIndex - startIndex;
    }

    @Override
    public void flush() {
        this.checkOpen();
        this.output.flush();
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.byteBufferLength != 0) {
                this.encodeByteBufferIntoOutput();
            }
            this.output.close();
        }
    }

    private final int copyIntoByteBuffer(byte[] source2, int startIndex, int endIndex) {
        int bytesToCopy = Math.min(3 - this.byteBufferLength, endIndex - startIndex);
        ArraysKt.copyInto(source2, this.byteBuffer, this.byteBufferLength, startIndex, startIndex + bytesToCopy);
        this.byteBufferLength += bytesToCopy;
        if (this.byteBufferLength == 3) {
            this.encodeByteBufferIntoOutput();
        }
        return bytesToCopy;
    }

    private final void encodeByteBufferIntoOutput() {
        boolean bl;
        int symbolsEncoded = this.encodeIntoOutput(this.byteBuffer, 0, this.byteBufferLength);
        boolean bl2 = bl = symbolsEncoded == 4;
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.byteBufferLength = 0;
    }

    private final int encodeIntoOutput(byte[] source2, int startIndex, int endIndex) {
        int symbolsEncoded = this.base64.encodeIntoByteArray(source2, this.symbolBuffer, 0, startIndex, endIndex);
        if (this.lineLength == 0) {
            boolean bl;
            this.output.write(Base64.Default.getMimeLineSeparatorSymbols$kotlin_stdlib());
            this.lineLength = 76;
            boolean bl2 = bl = symbolsEncoded <= 76;
            if (!bl) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
        this.output.write(this.symbolBuffer, 0, symbolsEncoded);
        this.lineLength -= symbolsEncoded;
        return symbolsEncoded;
    }

    private final void checkOpen() {
        if (this.isClosed) {
            throw new IOException("The output stream is closed.");
        }
    }
}

