/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.resources.ProcessArguments;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class MainJarPathFinder {
    private final Supplier<String[]> getProcessHandleArguments;
    private final Function<String, String> getSystemProperty;
    private final Predicate<Path> fileExists;

    public MainJarPathFinder() {
        this(ProcessArguments::getProcessArguments, System::getProperty, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    MainJarPathFinder(Supplier<String[]> getProcessHandleArguments, Function<String, String> getSystemProperty, Predicate<Path> fileExists) {
        this.getProcessHandleArguments = getProcessHandleArguments;
        this.getSystemProperty = getSystemProperty;
        this.fileExists = fileExists;
    }

    Path detectJarPath() {
        Path jarPath = this.getJarPathFromProcessHandle();
        if (jarPath != null) {
            return jarPath;
        }
        return this.getJarPathFromSunCommandLine();
    }

    @Nullable
    private Path getJarPathFromProcessHandle() {
        String[] javaArgs = this.getProcessHandleArguments.get();
        boolean jarOptionFound = false;
        for (String javaArg : javaArgs) {
            if ("-jar".equals(javaArg)) {
                jarOptionFound = true;
                continue;
            }
            if (!jarOptionFound || javaArg.startsWith("-")) continue;
            return Paths.get(javaArg, new String[0]);
        }
        return null;
    }

    @Nullable
    private Path getJarPathFromSunCommandLine() {
        Path path;
        String programArguments = this.getSystemProperty.apply("sun.java.command");
        if (programArguments == null) {
            return null;
        }
        int next = 0;
        do {
            int nextSpace;
            if ((nextSpace = programArguments.indexOf(32, next)) == -1) {
                return this.pathIfExists(programArguments);
            }
            path = this.pathIfExists(programArguments.substring(0, nextSpace));
            next = nextSpace + 1;
        } while (path == null);
        return path;
    }

    @Nullable
    private Path pathIfExists(String programArguments) {
        Path candidate;
        try {
            candidate = Paths.get(programArguments, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
        return this.fileExists.test(candidate) ? candidate : null;
    }
}

