/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.resources;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.internal.OtelEncodingUtils;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.resources.ContainerResource;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

final class CgroupV1ContainerIdExtractor {
    private static final Logger logger = Logger.getLogger(CgroupV1ContainerIdExtractor.class.getName());
    static final Path V1_CGROUP_PATH = Paths.get("/proc/self/cgroup", new String[0]);
    private final ContainerResource.Filesystem filesystem;

    CgroupV1ContainerIdExtractor() {
        this(ContainerResource.FILESYSTEM_INSTANCE);
    }

    CgroupV1ContainerIdExtractor(ContainerResource.Filesystem filesystem) {
        this.filesystem = filesystem;
    }

    Optional<String> extractContainerId() {
        Optional<String> optional;
        block9: {
            if (!this.filesystem.isReadable(V1_CGROUP_PATH)) {
                return Optional.empty();
            }
            Stream<String> lines = this.filesystem.lines(V1_CGROUP_PATH);
            try {
                optional = lines.filter(line -> !line.isEmpty()).map(CgroupV1ContainerIdExtractor::getIdFromLine).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
                if (lines == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Unable to read file", e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private static Optional<String> getIdFromLine(String line) {
        String containerId;
        int lastSlashIdx = line.lastIndexOf(47);
        if (lastSlashIdx < 0) {
            return Optional.empty();
        }
        String lastSection = line.substring(lastSlashIdx + 1);
        int colonIdx = lastSection.lastIndexOf(58);
        if (colonIdx != -1) {
            containerId = lastSection.substring(colonIdx + 1);
        } else {
            int startIdx = lastSection.lastIndexOf(45);
            int endIdx = lastSection.lastIndexOf(46);
            int n = startIdx = startIdx == -1 ? 0 : startIdx + 1;
            if (endIdx == -1) {
                endIdx = lastSection.length();
            }
            if (startIdx > endIdx) {
                return Optional.empty();
            }
            containerId = lastSection.substring(startIdx, endIdx);
        }
        if (OtelEncodingUtils.isValidBase16String(containerId) && containerId.length() == 64) {
            return Optional.of(containerId);
        }
        return Optional.empty();
    }
}

