/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.http;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.instrumenter.AttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal.AttributesExtractorUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal.SpanKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal.SpanKeyProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.http.HttpCommonAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.http.HttpStatusCodeConverter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.network.internal.InternalClientAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.network.internal.InternalServerAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.semconv.url.internal.InternalUrlAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.semconv.HttpAttributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.semconv.UserAgentAttributes;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalUrlAttributesExtractor<REQUEST> internalUrlExtractor;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final InternalServerAttributesExtractor<REQUEST> internalServerExtractor;
    private final InternalClientAttributesExtractor<REQUEST> internalClientExtractor;
    private final Function<Context, String> httpRouteGetter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder) {
        super(builder.httpAttributesGetter, HttpStatusCodeConverter.SERVER, builder.capturedRequestHeaders, builder.capturedResponseHeaders, builder.knownMethods);
        this.internalUrlExtractor = builder.buildUrlExtractor();
        this.internalNetworkExtractor = builder.buildNetworkExtractor();
        this.internalServerExtractor = builder.buildServerExtractor();
        this.internalClientExtractor = builder.buildClientExtractor();
        this.httpRouteGetter = builder.httpRouteGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.internalUrlExtractor.onStart(attributes, request);
        this.internalServerExtractor.onStart(attributes, request);
        this.internalClientExtractor.onStart(attributes, request);
        AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).getHttpRoute(request));
        AttributesExtractorUtil.internalSet(attributes, UserAgentAttributes.USER_AGENT_ORIGINAL, this.userAgent(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_ROUTE, this.httpRouteGetter.apply(context));
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }

    @Nullable
    private String userAgent(REQUEST request) {
        return HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getHttpRequestHeader(request, "user-agent"));
    }
}

