/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.trace.Span;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.ContextKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.ImplicitContextKeyed;
import javax.annotation.Nullable;

public final class HttpRouteState
implements ImplicitContextKeyed {
    private static final ContextKey<HttpRouteState> KEY = ContextKey.named("opentelemetry-http-server-route-key");
    @Nullable
    private final String method;
    @Nullable
    private volatile String route;
    private volatile int updatedBySourceOrder;
    @Nullable
    private volatile Span span;

    @Nullable
    public static HttpRouteState fromContextOrNull(Context context) {
        return context.get(KEY);
    }

    public static void updateSpan(Context context, Span span) {
        HttpRouteState state = HttpRouteState.fromContextOrNull(context);
        if (state != null && state.span == null) {
            state.span = span;
        }
    }

    public static HttpRouteState create(@Nullable String method, @Nullable String route, int updatedBySourceOrder) {
        return HttpRouteState.create(method, route, updatedBySourceOrder, null);
    }

    public static HttpRouteState create(@Nullable String method, @Nullable String route, int updatedBySourceOrder, Span span) {
        return new HttpRouteState(method, route, updatedBySourceOrder, span);
    }

    private HttpRouteState(@Nullable String method, @Nullable String route, int updatedBySourceOrder, Span span) {
        this.method = method;
        this.updatedBySourceOrder = updatedBySourceOrder;
        this.route = route;
        this.span = span;
    }

    @Override
    public Context storeInContext(Context context) {
        return context.with(KEY, this);
    }

    @Nullable
    public String getMethod() {
        return this.method;
    }

    public int getUpdatedBySourceOrder() {
        return this.updatedBySourceOrder;
    }

    @Nullable
    public String getRoute() {
        return this.route;
    }

    @Nullable
    public Span getSpan() {
        return this.span;
    }

    public void update(Context context, int updatedBySourceOrder, String route) {
        this.updatedBySourceOrder = updatedBySourceOrder;
        this.route = route;
    }
}

