/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ConfigPropertiesUtil {
    public static boolean getBoolean(String propertyName, boolean defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        return strValue == null ? defaultValue : Boolean.parseBoolean(strValue);
    }

    public static int getInt(String propertyName, int defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @Nullable
    public static String getString(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        return System.getenv(ConfigPropertiesUtil.toEnvVarName(propertyName));
    }

    public static String getString(String propertyName, String defaultValue) {
        String strValue = ConfigPropertiesUtil.getString(propertyName);
        return strValue == null ? defaultValue : strValue;
    }

    public static List<String> getList(String propertyName, List<String> defaultValue) {
        String value = ConfigPropertiesUtil.getString(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return ConfigPropertiesUtil.filterBlanksAndNulls(value.split(","));
    }

    private static List<String> filterBlanksAndNulls(String[] values2) {
        return Arrays.stream(values2).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static String toEnvVarName(String propertyName) {
        return propertyName.toUpperCase(Locale.ROOT).replace('-', '_').replace('.', '_');
    }

    private ConfigPropertiesUtil() {
    }
}

