/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.db;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

class MultiQuery {
    private final String mainIdentifier;
    private final String operation;
    private final Set<String> statements;

    private MultiQuery(String mainIdentifier, String operation, Set<String> statements) {
        this.mainIdentifier = mainIdentifier;
        this.operation = operation;
        this.statements = statements;
    }

    static MultiQuery analyze(Collection<String> rawQueryTexts, boolean statementSanitizationEnabled) {
        UniqueValue uniqueMainIdentifier = new UniqueValue();
        UniqueValue uniqueOperation = new UniqueValue();
        LinkedHashSet<String> uniqueStatements = new LinkedHashSet<String>();
        for (String rawQueryText : rawQueryTexts) {
            SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
            String mainIdentifier = sanitizedStatement.getMainIdentifier();
            uniqueMainIdentifier.set(mainIdentifier);
            String operation = sanitizedStatement.getOperation();
            uniqueOperation.set(operation);
            uniqueStatements.add(statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
        }
        return new MultiQuery(uniqueMainIdentifier.getValue(), uniqueOperation.getValue(), uniqueStatements);
    }

    public String getMainIdentifier() {
        return this.mainIdentifier;
    }

    public String getOperation() {
        return this.operation;
    }

    public Set<String> getStatements() {
        return this.statements;
    }

    private static class UniqueValue {
        private String value;
        private boolean valid = true;

        private UniqueValue() {
        }

        void set(String value) {
            if (!this.valid) {
                return;
            }
            if (this.value == null) {
                this.value = value;
            } else if (!this.value.equals(value)) {
                this.valid = false;
            }
        }

        String getValue() {
            return this.valid ? this.value : null;
        }
    }
}

