/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.traces;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.MarshalerWithSize;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.ProtoFieldInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.marshal.Serializer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.InstrumentationScopeMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.ResourceMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.traces.InstrumentationScopeSpansMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.internal.otlp.traces.SpanMarshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.proto.trace.v1.internal.ResourceSpans;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.InstrumentationScopeInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.resources.Resource;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class ResourceSpansMarshaler
extends MarshalerWithSize {
    private final ResourceMarshaler resourceMarshaler;
    private final byte[] schemaUrlUtf8;
    private final InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers;

    public static ResourceSpansMarshaler[] create(Collection<SpanData> spanDataList) {
        Map<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> resourceAndScopeMap = ResourceSpansMarshaler.groupByResourceAndScope(spanDataList);
        ResourceSpansMarshaler[] resourceSpansMarshalers = new ResourceSpansMarshaler[resourceAndScopeMap.size()];
        int posResource = 0;
        for (Map.Entry<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> entry : resourceAndScopeMap.entrySet()) {
            InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers = new InstrumentationScopeSpansMarshaler[entry.getValue().size()];
            int posInstrumentation = 0;
            for (Map.Entry<InstrumentationScopeInfo, List<SpanMarshaler>> entryIs : entry.getValue().entrySet()) {
                instrumentationScopeSpansMarshalers[posInstrumentation++] = new InstrumentationScopeSpansMarshaler(InstrumentationScopeMarshaler.create(entryIs.getKey()), MarshalerUtil.toBytes(entryIs.getKey().getSchemaUrl()), entryIs.getValue());
            }
            resourceSpansMarshalers[posResource++] = new ResourceSpansMarshaler(ResourceMarshaler.create(entry.getKey()), MarshalerUtil.toBytes(entry.getKey().getSchemaUrl()), instrumentationScopeSpansMarshalers);
        }
        return resourceSpansMarshalers;
    }

    ResourceSpansMarshaler(ResourceMarshaler resourceMarshaler, byte[] schemaUrlUtf8, InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers) {
        super(ResourceSpansMarshaler.calculateSize(resourceMarshaler, schemaUrlUtf8, instrumentationScopeSpansMarshalers));
        this.resourceMarshaler = resourceMarshaler;
        this.schemaUrlUtf8 = schemaUrlUtf8;
        this.instrumentationScopeSpansMarshalers = instrumentationScopeSpansMarshalers;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(ResourceSpans.RESOURCE, this.resourceMarshaler);
        output.serializeRepeatedMessage(ResourceSpans.SCOPE_SPANS, this.instrumentationScopeSpansMarshalers);
        output.serializeString(ResourceSpans.SCHEMA_URL, this.schemaUrlUtf8);
    }

    private static int calculateSize(ResourceMarshaler resourceMarshaler, byte[] schemaUrlUtf8, InstrumentationScopeSpansMarshaler[] instrumentationScopeSpansMarshalers) {
        int size = 0;
        size += MarshalerUtil.sizeMessage(ResourceSpans.RESOURCE, resourceMarshaler);
        size += MarshalerUtil.sizeBytes(ResourceSpans.SCHEMA_URL, schemaUrlUtf8);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ResourceSpans.SCOPE_SPANS, (Marshaler[])instrumentationScopeSpansMarshalers);
    }

    private static Map<Resource, Map<InstrumentationScopeInfo, List<SpanMarshaler>>> groupByResourceAndScope(Collection<SpanData> spanDataList) {
        return MarshalerUtil.groupByResourceAndScope(spanDataList, SpanData::getResource, SpanData::getInstrumentationScopeInfo, SpanMarshaler::create);
    }
}

