/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.baggage.propagation;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class BaggageCodec {
    private static final byte ESCAPE_CHAR = 37;
    private static final int RADIX = 16;

    private BaggageCodec() {
    }

    private static byte[] decode(byte[] bytes) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                try {
                    int u = BaggageCodec.digit16(bytes[++i]);
                    int l = BaggageCodec.digit16(bytes[++i]);
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("Invalid URL encoding: ", e);
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    static String decode(String value, Charset charset) {
        byte[] bytes = BaggageCodec.decode(value.getBytes(StandardCharsets.US_ASCII));
        return new String(bytes, charset);
    }

    private static int digit16(byte b) {
        int i = Character.digit((char)b, 16);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid URL encoding: not a valid digit (radix 16): " + b);
        }
        return i;
    }
}

