/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor;

import com.google.auto.value.AutoValue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.View;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.aggregator.AggregationUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.debug.SourceInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor.Advice;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor.AutoValue_MetricDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricDescriptor {
    private final AtomicReference<SourceInfo> viewSourceInfo = new AtomicReference();
    private int hashcode;

    public static MetricDescriptor create(String name, String description, String unit) {
        return MetricDescriptor.create(View.builder().build(), SourceInfo.fromCurrentStack(), InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE, Advice.empty()));
    }

    public static MetricDescriptor create(View view, SourceInfo viewSourceInfo, InstrumentDescriptor instrument) {
        String name = view.getName() == null ? instrument.getName() : view.getName();
        String description = view.getDescription() == null ? instrument.getDescription() : view.getDescription();
        AutoValue_MetricDescriptor metricDescriptor = new AutoValue_MetricDescriptor(name, description, view, instrument);
        metricDescriptor.viewSourceInfo.set(viewSourceInfo);
        return metricDescriptor;
    }

    MetricDescriptor() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract View getView();

    public final SourceInfo getViewSourceInfo() {
        SourceInfo sourceInfo = this.viewSourceInfo.get();
        return sourceInfo == null ? SourceInfo.noSourceInfo() : sourceInfo;
    }

    public abstract InstrumentDescriptor getSourceInstrument();

    public String getAggregationName() {
        return AggregationUtil.aggregationName(this.getView().getAggregation());
    }

    public final int hashCode() {
        int result = this.hashcode;
        if (result == 0) {
            result = 1;
            result *= 1000003;
            result ^= this.getName().toLowerCase(Locale.ROOT).hashCode();
            result *= 1000003;
            result ^= this.getDescription().hashCode();
            result *= 1000003;
            result ^= this.getView().hashCode();
            result *= 1000003;
            this.hashcode = result ^= this.getSourceInstrument().hashCode();
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricDescriptor) {
            MetricDescriptor that = (MetricDescriptor)o;
            return this.getName().equalsIgnoreCase(that.getName()) && this.getDescription().equals(that.getDescription()) && this.getView().equals(that.getView()) && this.getSourceInstrument().equals(that.getSourceInstrument());
        }
        return false;
    }
}

