/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.DoubleCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.LongCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.LongCounterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.ObservableLongCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.ObservableLongMeasurement;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.internal.ThrottlingLogger;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.AbstractInstrument;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentValueType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.SdkDoubleCounter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.SdkMeter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class SdkLongCounter
extends AbstractInstrument
implements LongCounter {
    private static final Logger logger = Logger.getLogger(SdkLongCounter.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkLongCounter(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        if (increment < 0L) {
            this.throttlingLogger.log(Level.WARNING, "Counters can only increase. Instrument " + this.getDescriptor().getName() + " has recorded a negative value.");
            return;
        }
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    static class SdkLongCounterBuilder
    implements LongCounterBuilder {
        final InstrumentBuilder builder;

        SdkLongCounterBuilder(SdkMeter sdkMeter, String name) {
            this.builder = new InstrumentBuilder(name, InstrumentType.COUNTER, InstrumentValueType.LONG, sdkMeter);
        }

        @Override
        public LongCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongCounter build() {
            return this.builder.buildSynchronousInstrument(SdkLongCounter::new);
        }

        @Override
        public DoubleCounterBuilder ofDoubles() {
            return this.builder.swapBuilder(SdkDoubleCounter.SdkDoubleCounterBuilder::new);
        }

        @Override
        public ObservableLongCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_COUNTER, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_COUNTER);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

