/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.export;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.common.CompletableResultCode;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.LogRecordProcessor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.ReadWriteLogRecord;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.data.LogRecordData;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.export.LogRecordExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleLogRecordProcessor
implements LogRecordProcessor {
    private static final Logger logger = Logger.getLogger(SimpleLogRecordProcessor.class.getName());
    private final LogRecordExporter logRecordExporter;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final Object exporterLock = new Object();

    public static LogRecordProcessor create(LogRecordExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleLogRecordProcessor(exporter);
    }

    private SimpleLogRecordProcessor(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        try {
            CompletableResultCode result;
            List<LogRecordData> logs = Collections.singletonList(logRecord.toLogRecordData());
            Object object = this.exporterLock;
            synchronized (object) {
                result = this.logRecordExporter.export(logs);
            }
            this.pendingExports.add(result);
            result.whenComplete(() -> {
                this.pendingExports.remove(result);
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.logRecordExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public LogRecordExporter getLogRecordExporter() {
        return this.logRecordExporter;
    }

    public String toString() {
        return "SimpleLogRecordProcessor{logRecordExporter=" + this.logRecordExporter + '}';
    }
}

