/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.metric.viewconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.metric.viewconfig.ViewConfig;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.SdkMeterProviderBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ViewConfigCustomizer
implements AutoConfigurationCustomizerProvider {
    @Override
    public void customize(AutoConfigurationCustomizer autoConfiguration) {
        autoConfiguration.addMeterProviderCustomizer(ViewConfigCustomizer::customizeMeterProvider);
    }

    static SdkMeterProviderBuilder customizeMeterProvider(SdkMeterProviderBuilder meterProviderBuilder, ConfigProperties configProperties) {
        List<String> configFileLocations = configProperties.getList("otel.experimental.metrics.view.config");
        for (String configFileLocation : configFileLocations) {
            if (configFileLocation.startsWith("classpath:")) {
                String classpathLocation = configFileLocation.substring("classpath:".length());
                try {
                    InputStream inputStream2 = ViewConfigCustomizer.class.getResourceAsStream(classpathLocation);
                    try {
                        if (inputStream2 == null) {
                            throw new ConfigurationException("Resource " + classpathLocation + " not found on classpath of classloader " + ViewConfigCustomizer.class.getClassLoader().getClass().getName());
                        }
                        ViewConfig.registerViews(meterProviderBuilder, inputStream2);
                        continue;
                    }
                    finally {
                        if (inputStream2 == null) continue;
                        inputStream2.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    throw new ConfigurationException("An error occurred reading view config resource on classpath: " + classpathLocation, e);
                }
            }
            try (FileInputStream fileInputStream = new FileInputStream(configFileLocation);){
                ViewConfig.registerViews(meterProviderBuilder, fileInputStream);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("View config file not found: " + configFileLocation, e);
            }
            catch (IOException e) {
                throw new ConfigurationException("An error occurred reading view config file: " + configFileLocation, e);
            }
        }
        return meterProviderBuilder;
    }
}

