/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.metric.viewconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.metric.viewconfig.SelectorSpecification;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.metric.viewconfig.ViewConfigSpecification;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.metric.viewconfig.ViewSpecification;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.Aggregation;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentSelectorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentType;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.SdkMeterProviderBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.View;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.ViewBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.internal.aggregator.AggregationUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;

public final class ViewConfig {
    private ViewConfig() {
    }

    public static void registerViews(SdkMeterProviderBuilder meterProviderBuilder, InputStream inputStream2) {
        List<ViewConfigSpecification> viewConfigSpecs = ViewConfig.loadViewConfig(inputStream2);
        for (ViewConfigSpecification viewConfigSpec : viewConfigSpecs) {
            meterProviderBuilder.registerView(ViewConfig.toInstrumentSelector(viewConfigSpec.getSelectorSpecification()), ViewConfig.toView(viewConfigSpec.getViewSpecification()));
        }
    }

    static List<ViewConfigSpecification> loadViewConfig(InputStream inputStream2) {
        LoadSettings settings = LoadSettings.builder().build();
        Load yaml = new Load(settings);
        try {
            ArrayList<ViewConfigSpecification> result = new ArrayList<ViewConfigSpecification>();
            List viewConfigs = (List)yaml.loadFromInputStream(inputStream2);
            for (Map viewConfigSpecMap : viewConfigs) {
                Map selectorSpecMap = Objects.requireNonNull(ViewConfig.getAsType(viewConfigSpecMap, "selector", Map.class), "selector is required");
                Map viewSpecMap = Objects.requireNonNull(ViewConfig.getAsType(viewConfigSpecMap, "view", Map.class), "view is required");
                InstrumentType instrumentType = Optional.ofNullable(ViewConfig.getAsType(selectorSpecMap, "instrument_type", String.class)).map(InstrumentType::valueOf).orElse(null);
                List attributeKeys = Optional.ofNullable(ViewConfig.getAsType(viewSpecMap, "attribute_keys", List.class)).map(objects -> objects.stream().map(String::valueOf).collect(Collectors.toList())).orElse(null);
                result.add(ViewConfigSpecification.builder().selectorSpecification(SelectorSpecification.builder().instrumentName(ViewConfig.getAsType(selectorSpecMap, "instrument_name", String.class)).instrumentType(instrumentType).instrumentUnit(ViewConfig.getAsType(selectorSpecMap, "instrument_unit", String.class)).meterName(ViewConfig.getAsType(selectorSpecMap, "meter_name", String.class)).meterVersion(ViewConfig.getAsType(selectorSpecMap, "meter_version", String.class)).meterSchemaUrl(ViewConfig.getAsType(selectorSpecMap, "meter_schema_url", String.class)).build()).viewSpecification(ViewSpecification.builder().name(ViewConfig.getAsType(viewSpecMap, "name", String.class)).description(ViewConfig.getAsType(viewSpecMap, "description", String.class)).aggregation(ViewConfig.getAsType(viewSpecMap, "aggregation", String.class)).aggregationArgs(ViewConfig.getAsType(viewSpecMap, "aggregation_args", Map.class)).attributeKeys(attributeKeys).build()).build());
            }
            return result;
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Failed to parse view config", e);
        }
    }

    @Nullable
    private static <T> T getAsType(Map<String, Object> map, String key, Class<T> type) {
        Object value = map.get(key);
        if (value != null && !type.isInstance(value)) {
            throw new IllegalStateException("Expected " + key + " to be type " + type.getName() + " but was " + value.getClass().getName());
        }
        return (T)value;
    }

    static View toView(ViewSpecification viewSpec) {
        List<String> attributeKeys;
        String aggregation;
        String description;
        ViewBuilder builder = View.builder();
        String name = viewSpec.getName();
        if (name != null) {
            builder.setName(name);
        }
        if ((description = viewSpec.getDescription()) != null) {
            builder.setDescription(description);
        }
        if ((aggregation = viewSpec.getAggregation()) != null) {
            Map<String, Object> aggregationArgs = viewSpec.getAggregationArgs() == null ? Collections.emptyMap() : viewSpec.getAggregationArgs();
            builder.setAggregation(ViewConfig.toAggregation(aggregation, aggregationArgs));
        }
        if ((attributeKeys = viewSpec.getAttributeKeys()) != null) {
            HashSet<String> keySet = new HashSet<String>(attributeKeys);
            builder.setAttributeFilter(keySet::contains);
        }
        return builder.build();
    }

    static Aggregation toAggregation(String aggregationName, Map<String, Object> aggregationArgs) {
        List<Double> bucketBoundaries;
        Aggregation aggregation;
        try {
            aggregation = AggregationUtil.forName(aggregationName);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Error creating aggregation", e);
        }
        if (Aggregation.explicitBucketHistogram().equals(aggregation) && (bucketBoundaries = ViewConfig.getBucketBoundaries(aggregationArgs)) != null) {
            return Aggregation.explicitBucketHistogram(bucketBoundaries);
        }
        if (Aggregation.base2ExponentialBucketHistogram().equals(aggregation)) {
            Integer maxBuckets;
            try {
                maxBuckets = ViewConfig.getAsType(aggregationArgs, "max_buckets", Integer.class);
            }
            catch (IllegalStateException e) {
                throw new ConfigurationException("max_buckets must be an integer", e);
            }
            if (maxBuckets != null) {
                return Aggregation.base2ExponentialBucketHistogram(maxBuckets, 20);
            }
        }
        return aggregation;
    }

    @Nullable
    private static List<Double> getBucketBoundaries(Map<String, Object> aggregationArgs) {
        List boundaryObjects = ViewConfig.getAsType(aggregationArgs, "bucket_boundaries", List.class);
        if (boundaryObjects == null) {
            return null;
        }
        return boundaryObjects.stream().map(o -> {
            if (!(o instanceof Number)) {
                throw new ConfigurationException("bucket_boundaries must be an array of numbers");
            }
            return ((Number)o).doubleValue();
        }).collect(Collectors.toList());
    }

    static InstrumentSelector toInstrumentSelector(SelectorSpecification selectorSpec) {
        String meterSchemaUrl;
        String meterVersion;
        String meterName;
        String instrumentUnit;
        InstrumentType instrumentType;
        InstrumentSelectorBuilder builder = InstrumentSelector.builder();
        String instrumentName = selectorSpec.getInstrumentName();
        if (instrumentName != null) {
            builder.setName(instrumentName);
        }
        if ((instrumentType = selectorSpec.getInstrumentType()) != null) {
            builder.setType(instrumentType);
        }
        if ((instrumentUnit = selectorSpec.getInstrumentUnit()) != null) {
            builder.setUnit(instrumentUnit);
        }
        if ((meterName = selectorSpec.getMeterName()) != null) {
            builder.setMeterName(meterName);
        }
        if ((meterVersion = selectorSpec.getMeterVersion()) != null) {
            builder.setMeterVersion(meterVersion);
        }
        if ((meterSchemaUrl = selectorSpec.getMeterSchemaUrl()) != null) {
            builder.setMeterSchemaUrl(meterSchemaUrl);
        }
        return builder.build();
    }
}

