/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.OtlpMetricModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.PushMetricExporterModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.export.MetricExporter;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class MetricExporterFactory
implements Factory<PushMetricExporterModel, MetricExporter> {
    private static final MetricExporterFactory INSTANCE = new MetricExporterFactory();

    private MetricExporterFactory() {
    }

    static MetricExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public MetricExporter create(PushMetricExporterModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        OtlpMetricModel otlpModel = model.getOtlp();
        if (otlpModel != null) {
            model.getAdditionalProperties().put("otlp", otlpModel);
        }
        if (model.getConsole() != null) {
            model.getAdditionalProperties().put("console", model.getConsole());
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new DeclarativeConfigException("Invalid configuration - multiple metric exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing exporter. This is a programming error."));
            MetricExporter metricExporter = FileConfigUtil.loadComponent(spiHelper, MetricExporter.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, metricExporter);
        }
        throw new DeclarativeConfigException("metric exporter must be set");
    }
}

