/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.LogLimitsFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.LogRecordLimitsAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.LogRecordProcessorFactory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.LoggerProviderAndAttributeLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.LoggerProviderModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.LogLimits;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.SdkLoggerProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.logs.SdkLoggerProviderBuilder;
import java.io.Closeable;
import java.util.List;

final class LoggerProviderFactory
implements Factory<LoggerProviderAndAttributeLimits, SdkLoggerProviderBuilder> {
    private static final LoggerProviderFactory INSTANCE = new LoggerProviderFactory();

    private LoggerProviderFactory() {
    }

    static LoggerProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkLoggerProviderBuilder create(LoggerProviderAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        SdkLoggerProviderBuilder builder = SdkLoggerProvider.builder();
        LoggerProviderModel loggerProviderModel = model.getLoggerProvider();
        if (loggerProviderModel == null) {
            return builder;
        }
        LogLimits logLimits = LogLimitsFactory.getInstance().create(LogRecordLimitsAndAttributeLimits.create(model.getAttributeLimits(), loggerProviderModel.getLimits()), spiHelper, closeables);
        builder.setLogLimits(() -> logLimits);
        List<LogRecordProcessorModel> processors = loggerProviderModel.getProcessors();
        if (processors != null) {
            processors.forEach(processor -> builder.addLogRecordProcessor(LogRecordProcessorFactory.getInstance().create((LogRecordProcessorModel)processor, spiHelper, closeables)));
        }
        return builder;
    }
}

