/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.Factory;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.SelectorModel;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentSelectorBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.metrics.InstrumentType;
import java.io.Closeable;
import java.util.List;

final class InstrumentSelectorFactory
implements Factory<SelectorModel, InstrumentSelector> {
    private static final InstrumentSelectorFactory INSTANCE = new InstrumentSelectorFactory();

    private InstrumentSelectorFactory() {
    }

    static InstrumentSelectorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public InstrumentSelector create(SelectorModel model, SpiHelper spiHelper, List<Closeable> closeables) {
        InstrumentSelectorBuilder builder = InstrumentSelector.builder();
        if (model.getInstrumentName() != null) {
            builder.setName(model.getInstrumentName());
        }
        if (model.getInstrumentType() != null) {
            InstrumentType instrumentType;
            try {
                instrumentType = InstrumentType.valueOf(model.getInstrumentType().name());
            }
            catch (IllegalArgumentException e) {
                throw new DeclarativeConfigException("Unrecognized instrument type: " + (Object)((Object)model.getInstrumentType()), e);
            }
            builder.setType(instrumentType);
        }
        if (model.getMeterName() != null) {
            builder.setMeterName(model.getMeterName());
        }
        if (model.getMeterSchemaUrl() != null) {
            builder.setMeterSchemaUrl(model.getMeterSchemaUrl());
        }
        if (model.getMeterVersion() != null) {
            builder.setMeterVersion(model.getMeterVersion());
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new DeclarativeConfigException("Invalid selector", e);
        }
    }
}

