/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.SpiHelper;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfiguration;
import java.io.Closeable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class FileConfigUtil {
    private FileConfigUtil() {
    }

    static <T> T addAndReturn(List<Closeable> closeables, T closeable) {
        if (closeable instanceof Closeable) {
            closeables.add((Closeable)closeable);
        }
        return closeable;
    }

    static <T> T assertNotNull(@Nullable T object, String description) {
        if (object == null) {
            throw new NullPointerException(description + " is null");
        }
        return object;
    }

    static <T> T requireNonNull(@Nullable T object, String description) {
        if (object == null) {
            throw new DeclarativeConfigException(description + " is required but is null");
        }
        return object;
    }

    static <T> T loadComponent(SpiHelper spiHelper, Class<T> type, String name, Object model) {
        DeclarativeConfigProperties config = DeclarativeConfiguration.toConfigProperties(model, spiHelper.getComponentLoader());
        return FileConfigUtil.loadComponentHelper(spiHelper, type, name, config);
    }

    private static <T> T loadComponentHelper(SpiHelper spiHelper, Class<T> type, String name, DeclarativeConfigProperties config) {
        List<ComponentProvider> componentProviders = spiHelper.load(ComponentProvider.class);
        List matchedProviders = componentProviders.stream().map(componentProvider -> componentProvider).filter(componentProvider -> componentProvider.getType() == type && name.equals(componentProvider.getName())).collect(Collectors.toList());
        if (matchedProviders.isEmpty()) {
            throw new DeclarativeConfigException("No component provider detected for " + type.getName() + " with name \"" + name + "\".");
        }
        if (matchedProviders.size() > 1) {
            throw new DeclarativeConfigException("Component provider conflict. Multiple providers detected for " + type.getName() + " with name \"" + name + "\": " + componentProviders.stream().map(provider -> provider.getClass().getName()).collect(Collectors.joining(",", "[", "]")));
        }
        ComponentProvider provider2 = (ComponentProvider)matchedProviders.get(0);
        try {
            return provider2.create(config);
        }
        catch (Throwable throwable) {
            throw new DeclarativeConfigException("Error configuring " + type.getName() + " with name \"" + name + "\"", throwable);
        }
    }
}

