/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.ConfigProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.DeclarativeConfigException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.incubator.config.GlobalConfigProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.OpenTelemetrySdk;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.internal.ComponentLoader;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.resources.Resource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Logger;

final class IncubatingUtil {
    private IncubatingUtil() {
    }

    static AutoConfiguredOpenTelemetrySdk configureFromFile(Logger logger, String configurationFile, ComponentLoader componentLoader) {
        AutoConfiguredOpenTelemetrySdk autoConfiguredOpenTelemetrySdk;
        logger.fine("Autoconfiguring from configuration file: " + configurationFile);
        FileInputStream fis = new FileInputStream(configurationFile);
        try {
            Class<?> declarativeConfiguration = Class.forName("io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.DeclarativeConfiguration");
            Method parse = declarativeConfiguration.getMethod("parse", InputStream.class);
            Object model = parse.invoke(null, fis);
            Class<?> openTelemetryConfiguration = Class.forName("io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel");
            Method create = declarativeConfiguration.getMethod("create", openTelemetryConfiguration, ComponentLoader.class);
            OpenTelemetrySdk sdk = (OpenTelemetrySdk)create.invoke(null, model, componentLoader);
            Class<?> sdkConfigProvider = Class.forName("io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.extension.incubator.fileconfig.SdkConfigProvider");
            Method createFileConfigProvider = sdkConfigProvider.getMethod("create", openTelemetryConfiguration);
            ConfigProvider configProvider = (ConfigProvider)createFileConfigProvider.invoke(null, model);
            autoConfiguredOpenTelemetrySdk = AutoConfiguredOpenTelemetrySdk.create(sdk, Resource.getDefault(), null, configProvider);
        }
        catch (Throwable declarativeConfiguration) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {
                    declarativeConfiguration.addSuppressed(throwable);
                }
                throw declarativeConfiguration;
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Configuration file not found", e);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                throw new ConfigurationException("Error configuring from file. Is opentelemetry-sdk-extension-incubator on the classpath?", e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DeclarativeConfigException) {
                    throw IncubatingUtil.toConfigurationException((DeclarativeConfigException)cause);
                }
                throw new ConfigurationException("Unexpected error configuring from file", e);
            }
            catch (IOException e) {
                throw new ConfigurationException("Error closing file", e);
            }
        }
        fis.close();
        return autoConfiguredOpenTelemetrySdk;
    }

    private static ConfigurationException toConfigurationException(DeclarativeConfigException exception) {
        String message = Objects.requireNonNull(exception.getMessage());
        return new ConfigurationException(message, exception);
    }

    static void setGlobalConfigProvider(Object configProvider) {
        GlobalConfigProvider.set((ConfigProvider)configProvider);
    }
}

