/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal.ConfigPropertiesUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class SemconvStability {
    private static final boolean emitOldDatabaseSemconv;
    private static final boolean emitStableDatabaseSemconv;
    private static final Map<String, String> dbSystemNameMap;

    public static boolean emitOldDatabaseSemconv() {
        return emitOldDatabaseSemconv;
    }

    public static boolean emitStableDatabaseSemconv() {
        return emitStableDatabaseSemconv;
    }

    public static String stableDbSystemName(String oldDbSystem) {
        String dbSystemName = dbSystemNameMap.get(oldDbSystem);
        return dbSystemName != null ? dbSystemName : oldDbSystem;
    }

    private SemconvStability() {
    }

    static {
        boolean oldDatabase = true;
        boolean stableDatabase = false;
        String value = ConfigPropertiesUtil.getString("otel.semconv-stability.opt-in");
        if (value != null) {
            HashSet<String> values2 = new HashSet<String>(Arrays.asList(value.split(",")));
            if (values2.contains("database")) {
                oldDatabase = false;
                stableDatabase = true;
            }
            if (values2.contains("database/dup")) {
                oldDatabase = true;
                stableDatabase = true;
            }
        }
        emitOldDatabaseSemconv = oldDatabase;
        emitStableDatabaseSemconv = stableDatabase;
        dbSystemNameMap = new HashMap<String, String>();
        dbSystemNameMap.put("adabas", "softwareag.adabas");
        dbSystemNameMap.put("intersystems_cache", "intersystems.cache");
        dbSystemNameMap.put("cosmosdb", "azure.cosmosdb");
        dbSystemNameMap.put("db2", "ibm.db2");
        dbSystemNameMap.put("dynamodb", "aws.dynamodb");
        dbSystemNameMap.put("h2", "h2database");
        dbSystemNameMap.put("hanadb", "sap.hana");
        dbSystemNameMap.put("informix", "ibm.informix");
        dbSystemNameMap.put("ingres", "actian.ingres");
        dbSystemNameMap.put("maxdb", "sap.maxdb");
        dbSystemNameMap.put("mssql", "microsoft.sql_server");
        dbSystemNameMap.put("netezza", "ibm.netezza");
        dbSystemNameMap.put("oracle", "oracle.db");
        dbSystemNameMap.put("redshift", "aws.redshift");
        dbSystemNameMap.put("spanner", "gcp.spanner");
    }
}

