/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.genai;

import com.google.auto.value.AutoValue;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.AttributeKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.common.AttributesBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.DoubleHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.DoubleHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.LongHistogram;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.LongHistogramBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.Meter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.context.ContextKey;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.db.DbClientMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.genai.AutoValue_GenAiClientMetrics_State;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.genai.GenAiAttributesExtractor;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.incubator.semconv.genai.GenAiMetricsAdvice;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.instrumenter.OperationListener;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.instrumenter.OperationMetrics;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GenAiClientMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> GEN_AI_CLIENT_METRICS_STATE = ContextKey.named("gen-ai-client-metrics-state");
    private static final Logger logger = Logger.getLogger(DbClientMetrics.class.getName());
    static final AttributeKey<String> GEN_AI_TOKEN_TYPE = AttributeKey.stringKey("gen_ai.token.type");
    private final LongHistogram tokenUsage;
    private final DoubleHistogram operationDuration;

    public static OperationMetrics get() {
        return OperationMetricsUtil.create("gen_ai client", GenAiClientMetrics::new);
    }

    private GenAiClientMetrics(Meter meter) {
        LongHistogramBuilder tokenUsageBuilder = meter.histogramBuilder("gen_ai.client.token.usage").ofLongs().setUnit("{token}").setDescription("Measures number of input and output tokens used.").setExplicitBucketBoundariesAdvice(GenAiMetricsAdvice.CLIENT_TOKEN_USAGE_BUCKETS);
        GenAiMetricsAdvice.applyClientTokenUsageAdvice(tokenUsageBuilder);
        this.tokenUsage = tokenUsageBuilder.build();
        DoubleHistogramBuilder operationDurationBuilder = meter.histogramBuilder("gen_ai.client.operation.duration").setUnit("s").setDescription("GenAI operation duration.").setExplicitBucketBoundariesAdvice(GenAiMetricsAdvice.CLIENT_OPERATION_DURATION_BUCKETS);
        GenAiMetricsAdvice.applyClientOperationDurationAdvice(operationDurationBuilder);
        this.operationDuration = operationDurationBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(GEN_AI_CLIENT_METRICS_STATE, new AutoValue_GenAiClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long outputTokens;
        State state = context.get(GEN_AI_CLIENT_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record gen_ai operation metrics.", context);
            return;
        }
        AttributesBuilder attributesBuilder = state.startAttributes().toBuilder().putAll(endAttributes);
        this.operationDuration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributesBuilder.build(), context);
        Long inputTokens = endAttributes.get(GenAiAttributesExtractor.GEN_AI_USAGE_INPUT_TOKENS);
        if (inputTokens != null) {
            this.tokenUsage.record(inputTokens, attributesBuilder.put(GEN_AI_TOKEN_TYPE, "input").build(), context);
        }
        if ((outputTokens = endAttributes.get(GenAiAttributesExtractor.GEN_AI_USAGE_OUTPUT_TOKENS)) != null) {
            this.tokenUsage.record(outputTokens, attributesBuilder.put(GEN_AI_TOKEN_TYPE, "output").build(), context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

