/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.api.metrics.MeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.internal.OtlpConfigUtil;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.OpenTelemetrySdk;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigProperties;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.ConfigurationException;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_2_15_0_alpha.sdk.trace.export.SpanExporter;
import java.util.concurrent.atomic.AtomicReference;

public class OtlpSpanExporterProvider
implements ConfigurableSpanExporterProvider,
AutoConfigureListener {
    private final AtomicReference<MeterProvider> meterProviderRef = new AtomicReference<MeterProvider>(MeterProvider.noop());

    @Override
    public SpanExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("traces", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }

    @Override
    public void afterAutoConfigure(OpenTelemetrySdk sdk) {
        this.meterProviderRef.set(sdk.getMeterProvider());
    }
}

